package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.connect.model.primitives.{Timestamp, ContactId, InstanceId}
import scala.jdk.CollectionConverters._
final case class UpdateContactScheduleRequest(
    instanceId: InstanceId,
    contactId: ContactId,
    scheduledTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateContactScheduleRequest = {
    import UpdateContactScheduleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateContactScheduleRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .contactId(ContactId.unwrap(contactId): java.lang.String)
      .scheduledTime(Timestamp.unwrap(scheduledTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UpdateContactScheduleRequest.ReadOnly =
    zio.aws.connect.model.UpdateContactScheduleRequest.wrap(buildAwsValue())
}
object UpdateContactScheduleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateContactScheduleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateContactScheduleRequest =
      zio.aws.connect.model
        .UpdateContactScheduleRequest(instanceId, contactId, scheduledTime)
    def instanceId: InstanceId
    def contactId: ContactId
    def scheduledTime: Timestamp
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getContactId: ZIO[Any, Nothing, ContactId] = ZIO.succeed(contactId)
    def getScheduledTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(scheduledTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateContactScheduleRequest
  ) extends zio.aws.connect.model.UpdateContactScheduleRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val contactId: ContactId =
      zio.aws.connect.model.primitives.ContactId(impl.contactId())
    override val scheduledTime: Timestamp =
      zio.aws.connect.model.primitives.Timestamp(impl.scheduledTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateContactScheduleRequest
  ): zio.aws.connect.model.UpdateContactScheduleRequest.ReadOnly = new Wrapper(
    impl
  )
}
