package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  EvaluationFormDescription,
  InstanceId,
  VersionNumber,
  ClientToken,
  BoxedBoolean,
  ResourceId,
  EvaluationFormTitle
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateEvaluationFormRequest(
    instanceId: InstanceId,
    evaluationFormId: ResourceId,
    evaluationFormVersion: VersionNumber,
    createNewVersion: Optional[BoxedBoolean] = Optional.Absent,
    title: EvaluationFormTitle,
    description: Optional[EvaluationFormDescription] = Optional.Absent,
    items: Iterable[zio.aws.connect.model.EvaluationFormItem],
    scoringStrategy: Optional[
      zio.aws.connect.model.EvaluationFormScoringStrategy
    ] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateEvaluationFormRequest = {
    import UpdateEvaluationFormRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateEvaluationFormRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .evaluationFormId(ResourceId.unwrap(evaluationFormId): java.lang.String)
      .evaluationFormVersion(
        VersionNumber.unwrap(evaluationFormVersion): Integer
      )
      .optionallyWith(createNewVersion.map(value => value: java.lang.Boolean))(
        _.createNewVersion
      )
      .title(EvaluationFormTitle.unwrap(title): java.lang.String)
      .optionallyWith(
        description.map(value =>
          EvaluationFormDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .items(items.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(scoringStrategy.map(value => value.buildAwsValue()))(
        _.scoringStrategy
      )
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UpdateEvaluationFormRequest.ReadOnly =
    zio.aws.connect.model.UpdateEvaluationFormRequest.wrap(buildAwsValue())
}
object UpdateEvaluationFormRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateEvaluationFormRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateEvaluationFormRequest =
      zio.aws.connect.model.UpdateEvaluationFormRequest(
        instanceId,
        evaluationFormId,
        evaluationFormVersion,
        createNewVersion.map(value => value),
        title,
        description.map(value => value),
        items.map { item =>
          item.asEditable
        },
        scoringStrategy.map(value => value.asEditable),
        clientToken.map(value => value)
      )
    def instanceId: InstanceId
    def evaluationFormId: ResourceId
    def evaluationFormVersion: VersionNumber
    def createNewVersion: Optional[BoxedBoolean]
    def title: EvaluationFormTitle
    def description: Optional[EvaluationFormDescription]
    def items: List[zio.aws.connect.model.EvaluationFormItem.ReadOnly]
    def scoringStrategy
        : Optional[zio.aws.connect.model.EvaluationFormScoringStrategy.ReadOnly]
    def clientToken: Optional[ClientToken]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getEvaluationFormId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(evaluationFormId)
    def getEvaluationFormVersion: ZIO[Any, Nothing, VersionNumber] =
      ZIO.succeed(evaluationFormVersion)
    def getCreateNewVersion: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("createNewVersion", createNewVersion)
    def getTitle: ZIO[Any, Nothing, EvaluationFormTitle] = ZIO.succeed(title)
    def getDescription: ZIO[Any, AwsError, EvaluationFormDescription] =
      AwsError.unwrapOptionField("description", description)
    def getItems: ZIO[Any, Nothing, List[
      zio.aws.connect.model.EvaluationFormItem.ReadOnly
    ]] = ZIO.succeed(items)
    def getScoringStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.EvaluationFormScoringStrategy.ReadOnly
    ] = AwsError.unwrapOptionField("scoringStrategy", scoringStrategy)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateEvaluationFormRequest
  ) extends zio.aws.connect.model.UpdateEvaluationFormRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val evaluationFormId: ResourceId =
      zio.aws.connect.model.primitives.ResourceId(impl.evaluationFormId())
    override val evaluationFormVersion: VersionNumber =
      zio.aws.connect.model.primitives
        .VersionNumber(impl.evaluationFormVersion())
    override val createNewVersion: Optional[BoxedBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createNewVersion())
        .map(value => value: BoxedBoolean)
    override val title: EvaluationFormTitle =
      zio.aws.connect.model.primitives.EvaluationFormTitle(impl.title())
    override val description: Optional[EvaluationFormDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.connect.model.primitives.EvaluationFormDescription(value)
        )
    override val items
        : List[zio.aws.connect.model.EvaluationFormItem.ReadOnly] = impl
      .items()
      .asScala
      .map { item =>
        zio.aws.connect.model.EvaluationFormItem.wrap(item)
      }
      .toList
    override val scoringStrategy: Optional[
      zio.aws.connect.model.EvaluationFormScoringStrategy.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scoringStrategy())
      .map(value =>
        zio.aws.connect.model.EvaluationFormScoringStrategy.wrap(value)
      )
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.connect.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateEvaluationFormRequest
  ): zio.aws.connect.model.UpdateEvaluationFormRequest.ReadOnly = new Wrapper(
    impl
  )
}
