package zio.aws.connect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{VersionNumber, ARN, ResourceId}
import scala.jdk.CollectionConverters._
final case class UpdateEvaluationFormResponse(
    evaluationFormId: ResourceId,
    evaluationFormArn: ARN,
    evaluationFormVersion: VersionNumber
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateEvaluationFormResponse = {
    import UpdateEvaluationFormResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateEvaluationFormResponse
      .builder()
      .evaluationFormId(ResourceId.unwrap(evaluationFormId): java.lang.String)
      .evaluationFormArn(ARN.unwrap(evaluationFormArn): java.lang.String)
      .evaluationFormVersion(
        VersionNumber.unwrap(evaluationFormVersion): Integer
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UpdateEvaluationFormResponse.ReadOnly =
    zio.aws.connect.model.UpdateEvaluationFormResponse.wrap(buildAwsValue())
}
object UpdateEvaluationFormResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateEvaluationFormResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateEvaluationFormResponse =
      zio.aws.connect.model.UpdateEvaluationFormResponse(
        evaluationFormId,
        evaluationFormArn,
        evaluationFormVersion
      )
    def evaluationFormId: ResourceId
    def evaluationFormArn: ARN
    def evaluationFormVersion: VersionNumber
    def getEvaluationFormId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(evaluationFormId)
    def getEvaluationFormArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(evaluationFormArn)
    def getEvaluationFormVersion: ZIO[Any, Nothing, VersionNumber] =
      ZIO.succeed(evaluationFormVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateEvaluationFormResponse
  ) extends zio.aws.connect.model.UpdateEvaluationFormResponse.ReadOnly {
    override val evaluationFormId: ResourceId =
      zio.aws.connect.model.primitives.ResourceId(impl.evaluationFormId())
    override val evaluationFormArn: ARN =
      zio.aws.connect.model.primitives.ARN(impl.evaluationFormArn())
    override val evaluationFormVersion: VersionNumber =
      zio.aws.connect.model.primitives
        .VersionNumber(impl.evaluationFormVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateEvaluationFormResponse
  ): zio.aws.connect.model.UpdateEvaluationFormResponse.ReadOnly = new Wrapper(
    impl
  )
}
