package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{InstanceAttributeValue, InstanceId}
import scala.jdk.CollectionConverters._
final case class UpdateInstanceAttributeRequest(
    instanceId: InstanceId,
    attributeType: zio.aws.connect.model.InstanceAttributeType,
    value: InstanceAttributeValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateInstanceAttributeRequest = {
    import UpdateInstanceAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateInstanceAttributeRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .attributeType(attributeType.unwrap)
      .value(InstanceAttributeValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.UpdateInstanceAttributeRequest.ReadOnly =
    zio.aws.connect.model.UpdateInstanceAttributeRequest.wrap(buildAwsValue())
}
object UpdateInstanceAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateInstanceAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateInstanceAttributeRequest =
      zio.aws.connect.model
        .UpdateInstanceAttributeRequest(instanceId, attributeType, value)
    def instanceId: InstanceId
    def attributeType: zio.aws.connect.model.InstanceAttributeType
    def value: InstanceAttributeValue
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getAttributeType
        : ZIO[Any, Nothing, zio.aws.connect.model.InstanceAttributeType] =
      ZIO.succeed(attributeType)
    def getValue: ZIO[Any, Nothing, InstanceAttributeValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateInstanceAttributeRequest
  ) extends zio.aws.connect.model.UpdateInstanceAttributeRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val attributeType: zio.aws.connect.model.InstanceAttributeType =
      zio.aws.connect.model.InstanceAttributeType.wrap(impl.attributeType())
    override val value: InstanceAttributeValue =
      zio.aws.connect.model.primitives.InstanceAttributeValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateInstanceAttributeRequest
  ): zio.aws.connect.model.UpdateInstanceAttributeRequest.ReadOnly =
    new Wrapper(impl)
}
