package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateParticipantRoleConfigChannelInfo(
    chat: Optional[zio.aws.connect.model.ChatParticipantRoleConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateParticipantRoleConfigChannelInfo = {
    import UpdateParticipantRoleConfigChannelInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateParticipantRoleConfigChannelInfo
      .builder()
      .optionallyWith(chat.map(value => value.buildAwsValue()))(_.chat)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.UpdateParticipantRoleConfigChannelInfo.ReadOnly =
    zio.aws.connect.model.UpdateParticipantRoleConfigChannelInfo
      .wrap(buildAwsValue())
}
object UpdateParticipantRoleConfigChannelInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateParticipantRoleConfigChannelInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connect.model.UpdateParticipantRoleConfigChannelInfo =
      zio.aws.connect.model.UpdateParticipantRoleConfigChannelInfo(
        chat.map(value => value.asEditable)
      )
    def chat: Optional[zio.aws.connect.model.ChatParticipantRoleConfig.ReadOnly]
    def getChat: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.ChatParticipantRoleConfig.ReadOnly
    ] = AwsError.unwrapOptionField("chat", chat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateParticipantRoleConfigChannelInfo
  ) extends zio.aws.connect.model.UpdateParticipantRoleConfigChannelInfo.ReadOnly {
    override val chat
        : Optional[zio.aws.connect.model.ChatParticipantRoleConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.chat())
        .map(value =>
          zio.aws.connect.model.ChatParticipantRoleConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateParticipantRoleConfigChannelInfo
  ): zio.aws.connect.model.UpdateParticipantRoleConfigChannelInfo.ReadOnly =
    new Wrapper(impl)
}
