package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{ContactId, InstanceId}
import scala.jdk.CollectionConverters._
final case class UpdateParticipantRoleConfigRequest(
    instanceId: InstanceId,
    contactId: ContactId,
    channelConfiguration: zio.aws.connect.model.UpdateParticipantRoleConfigChannelInfo
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateParticipantRoleConfigRequest = {
    import UpdateParticipantRoleConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateParticipantRoleConfigRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .contactId(ContactId.unwrap(contactId): java.lang.String)
      .channelConfiguration(channelConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.UpdateParticipantRoleConfigRequest.ReadOnly =
    zio.aws.connect.model.UpdateParticipantRoleConfigRequest
      .wrap(buildAwsValue())
}
object UpdateParticipantRoleConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateParticipantRoleConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateParticipantRoleConfigRequest =
      zio.aws.connect.model.UpdateParticipantRoleConfigRequest(
        instanceId,
        contactId,
        channelConfiguration.asEditable
      )
    def instanceId: InstanceId
    def contactId: ContactId
    def channelConfiguration
        : zio.aws.connect.model.UpdateParticipantRoleConfigChannelInfo.ReadOnly
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getContactId: ZIO[Any, Nothing, ContactId] = ZIO.succeed(contactId)
    def getChannelConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.connect.model.UpdateParticipantRoleConfigChannelInfo.ReadOnly
    ] = ZIO.succeed(channelConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateParticipantRoleConfigRequest
  ) extends zio.aws.connect.model.UpdateParticipantRoleConfigRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val contactId: ContactId =
      zio.aws.connect.model.primitives.ContactId(impl.contactId())
    override val channelConfiguration
        : zio.aws.connect.model.UpdateParticipantRoleConfigChannelInfo.ReadOnly =
      zio.aws.connect.model.UpdateParticipantRoleConfigChannelInfo
        .wrap(impl.channelConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateParticipantRoleConfigRequest
  ): zio.aws.connect.model.UpdateParticipantRoleConfigRequest.ReadOnly =
    new Wrapper(impl)
}
