package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{ClientToken, ARN, PhoneNumberId}
import scala.jdk.CollectionConverters._
final case class UpdatePhoneNumberRequest(
    phoneNumberId: PhoneNumberId,
    targetArn: ARN,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdatePhoneNumberRequest = {
    import UpdatePhoneNumberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdatePhoneNumberRequest
      .builder()
      .phoneNumberId(PhoneNumberId.unwrap(phoneNumberId): java.lang.String)
      .targetArn(ARN.unwrap(targetArn): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UpdatePhoneNumberRequest.ReadOnly =
    zio.aws.connect.model.UpdatePhoneNumberRequest.wrap(buildAwsValue())
}
object UpdatePhoneNumberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdatePhoneNumberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdatePhoneNumberRequest =
      zio.aws.connect.model.UpdatePhoneNumberRequest(
        phoneNumberId,
        targetArn,
        clientToken.map(value => value)
      )
    def phoneNumberId: PhoneNumberId
    def targetArn: ARN
    def clientToken: Optional[ClientToken]
    def getPhoneNumberId: ZIO[Any, Nothing, PhoneNumberId] =
      ZIO.succeed(phoneNumberId)
    def getTargetArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(targetArn)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdatePhoneNumberRequest
  ) extends zio.aws.connect.model.UpdatePhoneNumberRequest.ReadOnly {
    override val phoneNumberId: PhoneNumberId =
      zio.aws.connect.model.primitives.PhoneNumberId(impl.phoneNumberId())
    override val targetArn: ARN =
      zio.aws.connect.model.primitives.ARN(impl.targetArn())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.connect.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdatePhoneNumberRequest
  ): zio.aws.connect.model.UpdatePhoneNumberRequest.ReadOnly = new Wrapper(impl)
}
