package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  S3Uri,
  InstanceId,
  CommonNameLength127,
  PromptDescription,
  PromptId
}
import scala.jdk.CollectionConverters._
final case class UpdatePromptRequest(
    instanceId: InstanceId,
    promptId: PromptId,
    name: Optional[CommonNameLength127] = Optional.Absent,
    description: Optional[PromptDescription] = Optional.Absent,
    s3Uri: Optional[S3Uri] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdatePromptRequest = {
    import UpdatePromptRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdatePromptRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .promptId(PromptId.unwrap(promptId): java.lang.String)
      .optionallyWith(
        name.map(value => CommonNameLength127.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          PromptDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        s3Uri.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.s3Uri)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UpdatePromptRequest.ReadOnly =
    zio.aws.connect.model.UpdatePromptRequest.wrap(buildAwsValue())
}
object UpdatePromptRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdatePromptRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdatePromptRequest =
      zio.aws.connect.model.UpdatePromptRequest(
        instanceId,
        promptId,
        name.map(value => value),
        description.map(value => value),
        s3Uri.map(value => value)
      )
    def instanceId: InstanceId
    def promptId: PromptId
    def name: Optional[CommonNameLength127]
    def description: Optional[PromptDescription]
    def s3Uri: Optional[S3Uri]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getPromptId: ZIO[Any, Nothing, PromptId] = ZIO.succeed(promptId)
    def getName: ZIO[Any, AwsError, CommonNameLength127] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, PromptDescription] =
      AwsError.unwrapOptionField("description", description)
    def getS3Uri: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("s3Uri", s3Uri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdatePromptRequest
  ) extends zio.aws.connect.model.UpdatePromptRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val promptId: PromptId =
      zio.aws.connect.model.primitives.PromptId(impl.promptId())
    override val name: Optional[CommonNameLength127] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connect.model.primitives.CommonNameLength127(value))
    override val description: Optional[PromptDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.connect.model.primitives.PromptDescription(value))
    override val s3Uri: Optional[S3Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Uri())
      .map(value => zio.aws.connect.model.primitives.S3Uri(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdatePromptRequest
  ): zio.aws.connect.model.UpdatePromptRequest.ReadOnly = new Wrapper(impl)
}
