package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{PromptId, ARN}
import scala.jdk.CollectionConverters._
final case class UpdatePromptResponse(
    promptARN: Optional[ARN] = Optional.Absent,
    promptId: Optional[PromptId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdatePromptResponse = {
    import UpdatePromptResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdatePromptResponse
      .builder()
      .optionallyWith(
        promptARN.map(value => ARN.unwrap(value): java.lang.String)
      )(_.promptARN)
      .optionallyWith(
        promptId.map(value => PromptId.unwrap(value): java.lang.String)
      )(_.promptId)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UpdatePromptResponse.ReadOnly =
    zio.aws.connect.model.UpdatePromptResponse.wrap(buildAwsValue())
}
object UpdatePromptResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdatePromptResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdatePromptResponse =
      zio.aws.connect.model.UpdatePromptResponse(
        promptARN.map(value => value),
        promptId.map(value => value)
      )
    def promptARN: Optional[ARN]
    def promptId: Optional[PromptId]
    def getPromptARN: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("promptARN", promptARN)
    def getPromptId: ZIO[Any, AwsError, PromptId] =
      AwsError.unwrapOptionField("promptId", promptId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdatePromptResponse
  ) extends zio.aws.connect.model.UpdatePromptResponse.ReadOnly {
    override val promptARN: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.promptARN())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val promptId: Optional[PromptId] = zio.aws.core.internal
      .optionalFromNullable(impl.promptId())
      .map(value => zio.aws.connect.model.primitives.PromptId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdatePromptResponse
  ): zio.aws.connect.model.UpdatePromptResponse.ReadOnly = new Wrapper(impl)
}
