package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{QueueId, InstanceId}
import scala.jdk.CollectionConverters._
final case class UpdateQueueOutboundCallerConfigRequest(
    instanceId: InstanceId,
    queueId: QueueId,
    outboundCallerConfig: zio.aws.connect.model.OutboundCallerConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateQueueOutboundCallerConfigRequest = {
    import UpdateQueueOutboundCallerConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateQueueOutboundCallerConfigRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .outboundCallerConfig(outboundCallerConfig.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.UpdateQueueOutboundCallerConfigRequest.ReadOnly =
    zio.aws.connect.model.UpdateQueueOutboundCallerConfigRequest
      .wrap(buildAwsValue())
}
object UpdateQueueOutboundCallerConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateQueueOutboundCallerConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connect.model.UpdateQueueOutboundCallerConfigRequest =
      zio.aws.connect.model.UpdateQueueOutboundCallerConfigRequest(
        instanceId,
        queueId,
        outboundCallerConfig.asEditable
      )
    def instanceId: InstanceId
    def queueId: QueueId
    def outboundCallerConfig
        : zio.aws.connect.model.OutboundCallerConfig.ReadOnly
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getOutboundCallerConfig: ZIO[
      Any,
      Nothing,
      zio.aws.connect.model.OutboundCallerConfig.ReadOnly
    ] = ZIO.succeed(outboundCallerConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateQueueOutboundCallerConfigRequest
  ) extends zio.aws.connect.model.UpdateQueueOutboundCallerConfigRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val queueId: QueueId =
      zio.aws.connect.model.primitives.QueueId(impl.queueId())
    override val outboundCallerConfig
        : zio.aws.connect.model.OutboundCallerConfig.ReadOnly =
      zio.aws.connect.model.OutboundCallerConfig
        .wrap(impl.outboundCallerConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateQueueOutboundCallerConfigRequest
  ): zio.aws.connect.model.UpdateQueueOutboundCallerConfigRequest.ReadOnly =
    new Wrapper(impl)
}
