package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{RoutingProfileId, InstanceId}
import scala.jdk.CollectionConverters._
final case class UpdateRoutingProfileAgentAvailabilityTimerRequest(
    instanceId: InstanceId,
    routingProfileId: RoutingProfileId,
    agentAvailabilityTimer: zio.aws.connect.model.AgentAvailabilityTimer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateRoutingProfileAgentAvailabilityTimerRequest = {
    import UpdateRoutingProfileAgentAvailabilityTimerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateRoutingProfileAgentAvailabilityTimerRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .routingProfileId(
        RoutingProfileId.unwrap(routingProfileId): java.lang.String
      )
      .agentAvailabilityTimer(agentAvailabilityTimer.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.UpdateRoutingProfileAgentAvailabilityTimerRequest.ReadOnly =
    zio.aws.connect.model.UpdateRoutingProfileAgentAvailabilityTimerRequest
      .wrap(buildAwsValue())
}
object UpdateRoutingProfileAgentAvailabilityTimerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateRoutingProfileAgentAvailabilityTimerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connect.model.UpdateRoutingProfileAgentAvailabilityTimerRequest =
      zio.aws.connect.model.UpdateRoutingProfileAgentAvailabilityTimerRequest(
        instanceId,
        routingProfileId,
        agentAvailabilityTimer
      )
    def instanceId: InstanceId
    def routingProfileId: RoutingProfileId
    def agentAvailabilityTimer: zio.aws.connect.model.AgentAvailabilityTimer
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getRoutingProfileId: ZIO[Any, Nothing, RoutingProfileId] =
      ZIO.succeed(routingProfileId)
    def getAgentAvailabilityTimer
        : ZIO[Any, Nothing, zio.aws.connect.model.AgentAvailabilityTimer] =
      ZIO.succeed(agentAvailabilityTimer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateRoutingProfileAgentAvailabilityTimerRequest
  ) extends zio.aws.connect.model.UpdateRoutingProfileAgentAvailabilityTimerRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val routingProfileId: RoutingProfileId =
      zio.aws.connect.model.primitives.RoutingProfileId(impl.routingProfileId())
    override val agentAvailabilityTimer
        : zio.aws.connect.model.AgentAvailabilityTimer =
      zio.aws.connect.model.AgentAvailabilityTimer
        .wrap(impl.agentAvailabilityTimer())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateRoutingProfileAgentAvailabilityTimerRequest
  ): zio.aws.connect.model.UpdateRoutingProfileAgentAvailabilityTimerRequest.ReadOnly =
    new Wrapper(impl)
}
