package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{RoutingProfileId, InstanceId}
import scala.jdk.CollectionConverters._
final case class UpdateRoutingProfileConcurrencyRequest(
    instanceId: InstanceId,
    routingProfileId: RoutingProfileId,
    mediaConcurrencies: Iterable[zio.aws.connect.model.MediaConcurrency]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateRoutingProfileConcurrencyRequest = {
    import UpdateRoutingProfileConcurrencyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateRoutingProfileConcurrencyRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .routingProfileId(
        RoutingProfileId.unwrap(routingProfileId): java.lang.String
      )
      .mediaConcurrencies(mediaConcurrencies.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.UpdateRoutingProfileConcurrencyRequest.ReadOnly =
    zio.aws.connect.model.UpdateRoutingProfileConcurrencyRequest
      .wrap(buildAwsValue())
}
object UpdateRoutingProfileConcurrencyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateRoutingProfileConcurrencyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connect.model.UpdateRoutingProfileConcurrencyRequest =
      zio.aws.connect.model.UpdateRoutingProfileConcurrencyRequest(
        instanceId,
        routingProfileId,
        mediaConcurrencies.map { item =>
          item.asEditable
        }
      )
    def instanceId: InstanceId
    def routingProfileId: RoutingProfileId
    def mediaConcurrencies
        : List[zio.aws.connect.model.MediaConcurrency.ReadOnly]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getRoutingProfileId: ZIO[Any, Nothing, RoutingProfileId] =
      ZIO.succeed(routingProfileId)
    def getMediaConcurrencies: ZIO[Any, Nothing, List[
      zio.aws.connect.model.MediaConcurrency.ReadOnly
    ]] = ZIO.succeed(mediaConcurrencies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateRoutingProfileConcurrencyRequest
  ) extends zio.aws.connect.model.UpdateRoutingProfileConcurrencyRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val routingProfileId: RoutingProfileId =
      zio.aws.connect.model.primitives.RoutingProfileId(impl.routingProfileId())
    override val mediaConcurrencies
        : List[zio.aws.connect.model.MediaConcurrency.ReadOnly] = impl
      .mediaConcurrencies()
      .asScala
      .map { item =>
        zio.aws.connect.model.MediaConcurrency.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateRoutingProfileConcurrencyRequest
  ): zio.aws.connect.model.UpdateRoutingProfileConcurrencyRequest.ReadOnly =
    new Wrapper(impl)
}
