package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{QueueId, RoutingProfileId, InstanceId}
import scala.jdk.CollectionConverters._
final case class UpdateRoutingProfileDefaultOutboundQueueRequest(
    instanceId: InstanceId,
    routingProfileId: RoutingProfileId,
    defaultOutboundQueueId: QueueId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateRoutingProfileDefaultOutboundQueueRequest = {
    import UpdateRoutingProfileDefaultOutboundQueueRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateRoutingProfileDefaultOutboundQueueRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .routingProfileId(
        RoutingProfileId.unwrap(routingProfileId): java.lang.String
      )
      .defaultOutboundQueueId(
        QueueId.unwrap(defaultOutboundQueueId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.UpdateRoutingProfileDefaultOutboundQueueRequest.ReadOnly =
    zio.aws.connect.model.UpdateRoutingProfileDefaultOutboundQueueRequest
      .wrap(buildAwsValue())
}
object UpdateRoutingProfileDefaultOutboundQueueRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateRoutingProfileDefaultOutboundQueueRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connect.model.UpdateRoutingProfileDefaultOutboundQueueRequest =
      zio.aws.connect.model.UpdateRoutingProfileDefaultOutboundQueueRequest(
        instanceId,
        routingProfileId,
        defaultOutboundQueueId
      )
    def instanceId: InstanceId
    def routingProfileId: RoutingProfileId
    def defaultOutboundQueueId: QueueId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getRoutingProfileId: ZIO[Any, Nothing, RoutingProfileId] =
      ZIO.succeed(routingProfileId)
    def getDefaultOutboundQueueId: ZIO[Any, Nothing, QueueId] =
      ZIO.succeed(defaultOutboundQueueId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateRoutingProfileDefaultOutboundQueueRequest
  ) extends zio.aws.connect.model.UpdateRoutingProfileDefaultOutboundQueueRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val routingProfileId: RoutingProfileId =
      zio.aws.connect.model.primitives.RoutingProfileId(impl.routingProfileId())
    override val defaultOutboundQueueId: QueueId =
      zio.aws.connect.model.primitives.QueueId(impl.defaultOutboundQueueId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateRoutingProfileDefaultOutboundQueueRequest
  ): zio.aws.connect.model.UpdateRoutingProfileDefaultOutboundQueueRequest.ReadOnly =
    new Wrapper(impl)
}
