package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{
  RuleFunction,
  RuleName,
  InstanceId,
  RuleId
}
import scala.jdk.CollectionConverters._
final case class UpdateRuleRequest(
    ruleId: RuleId,
    instanceId: InstanceId,
    name: RuleName,
    function: RuleFunction,
    actions: Iterable[zio.aws.connect.model.RuleAction],
    publishStatus: zio.aws.connect.model.RulePublishStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateRuleRequest = {
    import UpdateRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateRuleRequest
      .builder()
      .ruleId(RuleId.unwrap(ruleId): java.lang.String)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .name(RuleName.unwrap(name): java.lang.String)
      .function(RuleFunction.unwrap(function): java.lang.String)
      .actions(actions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .publishStatus(publishStatus.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UpdateRuleRequest.ReadOnly =
    zio.aws.connect.model.UpdateRuleRequest.wrap(buildAwsValue())
}
object UpdateRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateRuleRequest =
      zio.aws.connect.model.UpdateRuleRequest(
        ruleId,
        instanceId,
        name,
        function,
        actions.map { item =>
          item.asEditable
        },
        publishStatus
      )
    def ruleId: RuleId
    def instanceId: InstanceId
    def name: RuleName
    def function: RuleFunction
    def actions: List[zio.aws.connect.model.RuleAction.ReadOnly]
    def publishStatus: zio.aws.connect.model.RulePublishStatus
    def getRuleId: ZIO[Any, Nothing, RuleId] = ZIO.succeed(ruleId)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getName: ZIO[Any, Nothing, RuleName] = ZIO.succeed(name)
    def getFunction: ZIO[Any, Nothing, RuleFunction] = ZIO.succeed(function)
    def getActions
        : ZIO[Any, Nothing, List[zio.aws.connect.model.RuleAction.ReadOnly]] =
      ZIO.succeed(actions)
    def getPublishStatus
        : ZIO[Any, Nothing, zio.aws.connect.model.RulePublishStatus] =
      ZIO.succeed(publishStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateRuleRequest
  ) extends zio.aws.connect.model.UpdateRuleRequest.ReadOnly {
    override val ruleId: RuleId =
      zio.aws.connect.model.primitives.RuleId(impl.ruleId())
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val name: RuleName =
      zio.aws.connect.model.primitives.RuleName(impl.name())
    override val function: RuleFunction =
      zio.aws.connect.model.primitives.RuleFunction(impl.function())
    override val actions: List[zio.aws.connect.model.RuleAction.ReadOnly] = impl
      .actions()
      .asScala
      .map { item =>
        zio.aws.connect.model.RuleAction.wrap(item)
      }
      .toList
    override val publishStatus: zio.aws.connect.model.RulePublishStatus =
      zio.aws.connect.model.RulePublishStatus.wrap(impl.publishStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateRuleRequest
  ): zio.aws.connect.model.UpdateRuleRequest.ReadOnly = new Wrapper(impl)
}
