package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  SecurityProfilePolicyValue,
  SecurityProfilePolicyKey,
  SecurityProfileDescription,
  SecurityProfilePermission,
  InstanceId,
  TagRestrictedResourceName,
  SecurityProfileId
}
import scala.jdk.CollectionConverters._
final case class UpdateSecurityProfileRequest(
    description: Optional[SecurityProfileDescription] = Optional.Absent,
    permissions: Optional[Iterable[SecurityProfilePermission]] =
      Optional.Absent,
    securityProfileId: SecurityProfileId,
    instanceId: InstanceId,
    allowedAccessControlTags: Optional[
      Map[SecurityProfilePolicyKey, SecurityProfilePolicyValue]
    ] = Optional.Absent,
    tagRestrictedResources: Optional[Iterable[TagRestrictedResourceName]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateSecurityProfileRequest = {
    import UpdateSecurityProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateSecurityProfileRequest
      .builder()
      .optionallyWith(
        description.map(value =>
          SecurityProfileDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        permissions.map(value =>
          value.map { item =>
            SecurityProfilePermission.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.permissions)
      .securityProfileId(
        SecurityProfileId.unwrap(securityProfileId): java.lang.String
      )
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(
        allowedAccessControlTags.map(value =>
          value
            .map({ case (key, value) =>
              (SecurityProfilePolicyKey
                .unwrap(key): java.lang.String) -> (SecurityProfilePolicyValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.allowedAccessControlTags)
      .optionallyWith(
        tagRestrictedResources.map(value =>
          value.map { item =>
            TagRestrictedResourceName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.tagRestrictedResources)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UpdateSecurityProfileRequest.ReadOnly =
    zio.aws.connect.model.UpdateSecurityProfileRequest.wrap(buildAwsValue())
}
object UpdateSecurityProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateSecurityProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateSecurityProfileRequest =
      zio.aws.connect.model.UpdateSecurityProfileRequest(
        description.map(value => value),
        permissions.map(value => value),
        securityProfileId,
        instanceId,
        allowedAccessControlTags.map(value => value),
        tagRestrictedResources.map(value => value)
      )
    def description: Optional[SecurityProfileDescription]
    def permissions: Optional[List[SecurityProfilePermission]]
    def securityProfileId: SecurityProfileId
    def instanceId: InstanceId
    def allowedAccessControlTags
        : Optional[Map[SecurityProfilePolicyKey, SecurityProfilePolicyValue]]
    def tagRestrictedResources: Optional[List[TagRestrictedResourceName]]
    def getDescription: ZIO[Any, AwsError, SecurityProfileDescription] =
      AwsError.unwrapOptionField("description", description)
    def getPermissions: ZIO[Any, AwsError, List[SecurityProfilePermission]] =
      AwsError.unwrapOptionField("permissions", permissions)
    def getSecurityProfileId: ZIO[Any, Nothing, SecurityProfileId] =
      ZIO.succeed(securityProfileId)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getAllowedAccessControlTags: ZIO[Any, AwsError, Map[
      SecurityProfilePolicyKey,
      SecurityProfilePolicyValue
    ]] = AwsError.unwrapOptionField(
      "allowedAccessControlTags",
      allowedAccessControlTags
    )
    def getTagRestrictedResources
        : ZIO[Any, AwsError, List[TagRestrictedResourceName]] = AwsError
      .unwrapOptionField("tagRestrictedResources", tagRestrictedResources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateSecurityProfileRequest
  ) extends zio.aws.connect.model.UpdateSecurityProfileRequest.ReadOnly {
    override val description: Optional[SecurityProfileDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.connect.model.primitives.SecurityProfileDescription(value)
        )
    override val permissions: Optional[List[SecurityProfilePermission]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.primitives.SecurityProfilePermission(item)
          }.toList
        )
    override val securityProfileId: SecurityProfileId =
      zio.aws.connect.model.primitives
        .SecurityProfileId(impl.securityProfileId())
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val allowedAccessControlTags
        : Optional[Map[SecurityProfilePolicyKey, SecurityProfilePolicyValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowedAccessControlTags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.connect.model.primitives.SecurityProfilePolicyKey(
                key
              ) -> zio.aws.connect.model.primitives
                .SecurityProfilePolicyValue(value)
            })
            .toMap
        )
    override val tagRestrictedResources
        : Optional[List[TagRestrictedResourceName]] = zio.aws.core.internal
      .optionalFromNullable(impl.tagRestrictedResources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.primitives.TagRestrictedResourceName(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateSecurityProfileRequest
  ): zio.aws.connect.model.UpdateSecurityProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
