package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  TaskTemplateDescription,
  InstanceId,
  TaskTemplateId,
  TaskTemplateName,
  ContactFlowId
}
import scala.jdk.CollectionConverters._
final case class UpdateTaskTemplateRequest(
    taskTemplateId: TaskTemplateId,
    instanceId: InstanceId,
    name: Optional[TaskTemplateName] = Optional.Absent,
    description: Optional[TaskTemplateDescription] = Optional.Absent,
    contactFlowId: Optional[ContactFlowId] = Optional.Absent,
    constraints: Optional[zio.aws.connect.model.TaskTemplateConstraints] =
      Optional.Absent,
    defaults: Optional[zio.aws.connect.model.TaskTemplateDefaults] =
      Optional.Absent,
    status: Optional[zio.aws.connect.model.TaskTemplateStatus] =
      Optional.Absent,
    fields: Optional[Iterable[zio.aws.connect.model.TaskTemplateField]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateTaskTemplateRequest = {
    import UpdateTaskTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateTaskTemplateRequest
      .builder()
      .taskTemplateId(TaskTemplateId.unwrap(taskTemplateId): java.lang.String)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(
        name.map(value => TaskTemplateName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          TaskTemplateDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        contactFlowId.map(value =>
          ContactFlowId.unwrap(value): java.lang.String
        )
      )(_.contactFlowId)
      .optionallyWith(constraints.map(value => value.buildAwsValue()))(
        _.constraints
      )
      .optionallyWith(defaults.map(value => value.buildAwsValue()))(_.defaults)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        fields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fields)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UpdateTaskTemplateRequest.ReadOnly =
    zio.aws.connect.model.UpdateTaskTemplateRequest.wrap(buildAwsValue())
}
object UpdateTaskTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateTaskTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateTaskTemplateRequest =
      zio.aws.connect.model.UpdateTaskTemplateRequest(
        taskTemplateId,
        instanceId,
        name.map(value => value),
        description.map(value => value),
        contactFlowId.map(value => value),
        constraints.map(value => value.asEditable),
        defaults.map(value => value.asEditable),
        status.map(value => value),
        fields.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def taskTemplateId: TaskTemplateId
    def instanceId: InstanceId
    def name: Optional[TaskTemplateName]
    def description: Optional[TaskTemplateDescription]
    def contactFlowId: Optional[ContactFlowId]
    def constraints
        : Optional[zio.aws.connect.model.TaskTemplateConstraints.ReadOnly]
    def defaults: Optional[zio.aws.connect.model.TaskTemplateDefaults.ReadOnly]
    def status: Optional[zio.aws.connect.model.TaskTemplateStatus]
    def fields: Optional[List[zio.aws.connect.model.TaskTemplateField.ReadOnly]]
    def getTaskTemplateId: ZIO[Any, Nothing, TaskTemplateId] =
      ZIO.succeed(taskTemplateId)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getName: ZIO[Any, AwsError, TaskTemplateName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, TaskTemplateDescription] =
      AwsError.unwrapOptionField("description", description)
    def getContactFlowId: ZIO[Any, AwsError, ContactFlowId] =
      AwsError.unwrapOptionField("contactFlowId", contactFlowId)
    def getConstraints: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.TaskTemplateConstraints.ReadOnly
    ] = AwsError.unwrapOptionField("constraints", constraints)
    def getDefaults: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.TaskTemplateDefaults.ReadOnly
    ] = AwsError.unwrapOptionField("defaults", defaults)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.connect.model.TaskTemplateStatus] =
      AwsError.unwrapOptionField("status", status)
    def getFields: ZIO[Any, AwsError, List[
      zio.aws.connect.model.TaskTemplateField.ReadOnly
    ]] = AwsError.unwrapOptionField("fields", fields)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateTaskTemplateRequest
  ) extends zio.aws.connect.model.UpdateTaskTemplateRequest.ReadOnly {
    override val taskTemplateId: TaskTemplateId =
      zio.aws.connect.model.primitives.TaskTemplateId(impl.taskTemplateId())
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val name: Optional[TaskTemplateName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connect.model.primitives.TaskTemplateName(value))
    override val description: Optional[TaskTemplateDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.connect.model.primitives.TaskTemplateDescription(value)
        )
    override val contactFlowId: Optional[ContactFlowId] = zio.aws.core.internal
      .optionalFromNullable(impl.contactFlowId())
      .map(value => zio.aws.connect.model.primitives.ContactFlowId(value))
    override val constraints
        : Optional[zio.aws.connect.model.TaskTemplateConstraints.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.constraints())
        .map(value => zio.aws.connect.model.TaskTemplateConstraints.wrap(value))
    override val defaults
        : Optional[zio.aws.connect.model.TaskTemplateDefaults.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaults())
        .map(value => zio.aws.connect.model.TaskTemplateDefaults.wrap(value))
    override val status: Optional[zio.aws.connect.model.TaskTemplateStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.connect.model.TaskTemplateStatus.wrap(value))
    override val fields
        : Optional[List[zio.aws.connect.model.TaskTemplateField.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fields())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.TaskTemplateField.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateTaskTemplateRequest
  ): zio.aws.connect.model.UpdateTaskTemplateRequest.ReadOnly = new Wrapper(
    impl
  )
}
