package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.TrafficDistributionGroupIdOrArn
import scala.jdk.CollectionConverters._
final case class UpdateTrafficDistributionRequest(
    id: TrafficDistributionGroupIdOrArn,
    telephonyConfig: Optional[zio.aws.connect.model.TelephonyConfig] =
      Optional.Absent,
    signInConfig: Optional[zio.aws.connect.model.SignInConfig] =
      Optional.Absent,
    agentConfig: Optional[zio.aws.connect.model.AgentConfig] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateTrafficDistributionRequest = {
    import UpdateTrafficDistributionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateTrafficDistributionRequest
      .builder()
      .id(TrafficDistributionGroupIdOrArn.unwrap(id): java.lang.String)
      .optionallyWith(telephonyConfig.map(value => value.buildAwsValue()))(
        _.telephonyConfig
      )
      .optionallyWith(signInConfig.map(value => value.buildAwsValue()))(
        _.signInConfig
      )
      .optionallyWith(agentConfig.map(value => value.buildAwsValue()))(
        _.agentConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.UpdateTrafficDistributionRequest.ReadOnly =
    zio.aws.connect.model.UpdateTrafficDistributionRequest.wrap(buildAwsValue())
}
object UpdateTrafficDistributionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateTrafficDistributionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateTrafficDistributionRequest =
      zio.aws.connect.model.UpdateTrafficDistributionRequest(
        id,
        telephonyConfig.map(value => value.asEditable),
        signInConfig.map(value => value.asEditable),
        agentConfig.map(value => value.asEditable)
      )
    def id: TrafficDistributionGroupIdOrArn
    def telephonyConfig
        : Optional[zio.aws.connect.model.TelephonyConfig.ReadOnly]
    def signInConfig: Optional[zio.aws.connect.model.SignInConfig.ReadOnly]
    def agentConfig: Optional[zio.aws.connect.model.AgentConfig.ReadOnly]
    def getId: ZIO[Any, Nothing, TrafficDistributionGroupIdOrArn] =
      ZIO.succeed(id)
    def getTelephonyConfig
        : ZIO[Any, AwsError, zio.aws.connect.model.TelephonyConfig.ReadOnly] =
      AwsError.unwrapOptionField("telephonyConfig", telephonyConfig)
    def getSignInConfig
        : ZIO[Any, AwsError, zio.aws.connect.model.SignInConfig.ReadOnly] =
      AwsError.unwrapOptionField("signInConfig", signInConfig)
    def getAgentConfig
        : ZIO[Any, AwsError, zio.aws.connect.model.AgentConfig.ReadOnly] =
      AwsError.unwrapOptionField("agentConfig", agentConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateTrafficDistributionRequest
  ) extends zio.aws.connect.model.UpdateTrafficDistributionRequest.ReadOnly {
    override val id: TrafficDistributionGroupIdOrArn =
      zio.aws.connect.model.primitives
        .TrafficDistributionGroupIdOrArn(impl.id())
    override val telephonyConfig
        : Optional[zio.aws.connect.model.TelephonyConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.telephonyConfig())
        .map(value => zio.aws.connect.model.TelephonyConfig.wrap(value))
    override val signInConfig
        : Optional[zio.aws.connect.model.SignInConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.signInConfig())
        .map(value => zio.aws.connect.model.SignInConfig.wrap(value))
    override val agentConfig
        : Optional[zio.aws.connect.model.AgentConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.agentConfig())
        .map(value => zio.aws.connect.model.AgentConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateTrafficDistributionRequest
  ): zio.aws.connect.model.UpdateTrafficDistributionRequest.ReadOnly =
    new Wrapper(impl)
}
