package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{
  InstanceId,
  HierarchyGroupId,
  HierarchyGroupName
}
import scala.jdk.CollectionConverters._
final case class UpdateUserHierarchyGroupNameRequest(
    name: HierarchyGroupName,
    hierarchyGroupId: HierarchyGroupId,
    instanceId: InstanceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateUserHierarchyGroupNameRequest = {
    import UpdateUserHierarchyGroupNameRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateUserHierarchyGroupNameRequest
      .builder()
      .name(HierarchyGroupName.unwrap(name): java.lang.String)
      .hierarchyGroupId(
        HierarchyGroupId.unwrap(hierarchyGroupId): java.lang.String
      )
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.UpdateUserHierarchyGroupNameRequest.ReadOnly =
    zio.aws.connect.model.UpdateUserHierarchyGroupNameRequest
      .wrap(buildAwsValue())
}
object UpdateUserHierarchyGroupNameRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateUserHierarchyGroupNameRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateUserHierarchyGroupNameRequest =
      zio.aws.connect.model
        .UpdateUserHierarchyGroupNameRequest(name, hierarchyGroupId, instanceId)
    def name: HierarchyGroupName
    def hierarchyGroupId: HierarchyGroupId
    def instanceId: InstanceId
    def getName: ZIO[Any, Nothing, HierarchyGroupName] = ZIO.succeed(name)
    def getHierarchyGroupId: ZIO[Any, Nothing, HierarchyGroupId] =
      ZIO.succeed(hierarchyGroupId)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateUserHierarchyGroupNameRequest
  ) extends zio.aws.connect.model.UpdateUserHierarchyGroupNameRequest.ReadOnly {
    override val name: HierarchyGroupName =
      zio.aws.connect.model.primitives.HierarchyGroupName(impl.name())
    override val hierarchyGroupId: HierarchyGroupId =
      zio.aws.connect.model.primitives.HierarchyGroupId(impl.hierarchyGroupId())
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateUserHierarchyGroupNameRequest
  ): zio.aws.connect.model.UpdateUserHierarchyGroupNameRequest.ReadOnly =
    new Wrapper(impl)
}
