package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{InstanceId, UserId}
import scala.jdk.CollectionConverters._
final case class UpdateUserIdentityInfoRequest(
    identityInfo: zio.aws.connect.model.UserIdentityInfo,
    userId: UserId,
    instanceId: InstanceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateUserIdentityInfoRequest = {
    import UpdateUserIdentityInfoRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateUserIdentityInfoRequest
      .builder()
      .identityInfo(identityInfo.buildAwsValue())
      .userId(UserId.unwrap(userId): java.lang.String)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UpdateUserIdentityInfoRequest.ReadOnly =
    zio.aws.connect.model.UpdateUserIdentityInfoRequest.wrap(buildAwsValue())
}
object UpdateUserIdentityInfoRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateUserIdentityInfoRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateUserIdentityInfoRequest =
      zio.aws.connect.model.UpdateUserIdentityInfoRequest(
        identityInfo.asEditable,
        userId,
        instanceId
      )
    def identityInfo: zio.aws.connect.model.UserIdentityInfo.ReadOnly
    def userId: UserId
    def instanceId: InstanceId
    def getIdentityInfo
        : ZIO[Any, Nothing, zio.aws.connect.model.UserIdentityInfo.ReadOnly] =
      ZIO.succeed(identityInfo)
    def getUserId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userId)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateUserIdentityInfoRequest
  ) extends zio.aws.connect.model.UpdateUserIdentityInfoRequest.ReadOnly {
    override val identityInfo: zio.aws.connect.model.UserIdentityInfo.ReadOnly =
      zio.aws.connect.model.UserIdentityInfo.wrap(impl.identityInfo())
    override val userId: UserId =
      zio.aws.connect.model.primitives.UserId(impl.userId())
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateUserIdentityInfoRequest
  ): zio.aws.connect.model.UpdateUserIdentityInfoRequest.ReadOnly = new Wrapper(
    impl
  )
}
