package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{InstanceId, UserId}
import scala.jdk.CollectionConverters._
final case class UpdateUserPhoneConfigRequest(
    phoneConfig: zio.aws.connect.model.UserPhoneConfig,
    userId: UserId,
    instanceId: InstanceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateUserPhoneConfigRequest = {
    import UpdateUserPhoneConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateUserPhoneConfigRequest
      .builder()
      .phoneConfig(phoneConfig.buildAwsValue())
      .userId(UserId.unwrap(userId): java.lang.String)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UpdateUserPhoneConfigRequest.ReadOnly =
    zio.aws.connect.model.UpdateUserPhoneConfigRequest.wrap(buildAwsValue())
}
object UpdateUserPhoneConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateUserPhoneConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateUserPhoneConfigRequest =
      zio.aws.connect.model.UpdateUserPhoneConfigRequest(
        phoneConfig.asEditable,
        userId,
        instanceId
      )
    def phoneConfig: zio.aws.connect.model.UserPhoneConfig.ReadOnly
    def userId: UserId
    def instanceId: InstanceId
    def getPhoneConfig
        : ZIO[Any, Nothing, zio.aws.connect.model.UserPhoneConfig.ReadOnly] =
      ZIO.succeed(phoneConfig)
    def getUserId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userId)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateUserPhoneConfigRequest
  ) extends zio.aws.connect.model.UpdateUserPhoneConfigRequest.ReadOnly {
    override val phoneConfig: zio.aws.connect.model.UserPhoneConfig.ReadOnly =
      zio.aws.connect.model.UserPhoneConfig.wrap(impl.phoneConfig())
    override val userId: UserId =
      zio.aws.connect.model.primitives.UserId(impl.userId())
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateUserPhoneConfigRequest
  ): zio.aws.connect.model.UpdateUserPhoneConfigRequest.ReadOnly = new Wrapper(
    impl
  )
}
