package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{InstanceId, UserId, RoutingProfileId}
import scala.jdk.CollectionConverters._
final case class UpdateUserRoutingProfileRequest(
    routingProfileId: RoutingProfileId,
    userId: UserId,
    instanceId: InstanceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateUserRoutingProfileRequest = {
    import UpdateUserRoutingProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateUserRoutingProfileRequest
      .builder()
      .routingProfileId(
        RoutingProfileId.unwrap(routingProfileId): java.lang.String
      )
      .userId(UserId.unwrap(userId): java.lang.String)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.UpdateUserRoutingProfileRequest.ReadOnly =
    zio.aws.connect.model.UpdateUserRoutingProfileRequest.wrap(buildAwsValue())
}
object UpdateUserRoutingProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateUserRoutingProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateUserRoutingProfileRequest =
      zio.aws.connect.model
        .UpdateUserRoutingProfileRequest(routingProfileId, userId, instanceId)
    def routingProfileId: RoutingProfileId
    def userId: UserId
    def instanceId: InstanceId
    def getRoutingProfileId: ZIO[Any, Nothing, RoutingProfileId] =
      ZIO.succeed(routingProfileId)
    def getUserId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userId)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateUserRoutingProfileRequest
  ) extends zio.aws.connect.model.UpdateUserRoutingProfileRequest.ReadOnly {
    override val routingProfileId: RoutingProfileId =
      zio.aws.connect.model.primitives.RoutingProfileId(impl.routingProfileId())
    override val userId: UserId =
      zio.aws.connect.model.primitives.UserId(impl.userId())
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateUserRoutingProfileRequest
  ): zio.aws.connect.model.UpdateUserRoutingProfileRequest.ReadOnly =
    new Wrapper(impl)
}
