package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{ViewId, ViewsInstanceId}
import scala.jdk.CollectionConverters._
final case class UpdateViewContentRequest(
    instanceId: ViewsInstanceId,
    viewId: ViewId,
    status: zio.aws.connect.model.ViewStatus,
    content: zio.aws.connect.model.ViewInputContent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateViewContentRequest = {
    import UpdateViewContentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateViewContentRequest
      .builder()
      .instanceId(ViewsInstanceId.unwrap(instanceId): java.lang.String)
      .viewId(ViewId.unwrap(viewId): java.lang.String)
      .status(status.unwrap)
      .content(content.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UpdateViewContentRequest.ReadOnly =
    zio.aws.connect.model.UpdateViewContentRequest.wrap(buildAwsValue())
}
object UpdateViewContentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateViewContentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateViewContentRequest =
      zio.aws.connect.model.UpdateViewContentRequest(
        instanceId,
        viewId,
        status,
        content.asEditable
      )
    def instanceId: ViewsInstanceId
    def viewId: ViewId
    def status: zio.aws.connect.model.ViewStatus
    def content: zio.aws.connect.model.ViewInputContent.ReadOnly
    def getInstanceId: ZIO[Any, Nothing, ViewsInstanceId] =
      ZIO.succeed(instanceId)
    def getViewId: ZIO[Any, Nothing, ViewId] = ZIO.succeed(viewId)
    def getStatus: ZIO[Any, Nothing, zio.aws.connect.model.ViewStatus] =
      ZIO.succeed(status)
    def getContent
        : ZIO[Any, Nothing, zio.aws.connect.model.ViewInputContent.ReadOnly] =
      ZIO.succeed(content)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateViewContentRequest
  ) extends zio.aws.connect.model.UpdateViewContentRequest.ReadOnly {
    override val instanceId: ViewsInstanceId =
      zio.aws.connect.model.primitives.ViewsInstanceId(impl.instanceId())
    override val viewId: ViewId =
      zio.aws.connect.model.primitives.ViewId(impl.viewId())
    override val status: zio.aws.connect.model.ViewStatus =
      zio.aws.connect.model.ViewStatus.wrap(impl.status())
    override val content: zio.aws.connect.model.ViewInputContent.ReadOnly =
      zio.aws.connect.model.ViewInputContent.wrap(impl.content())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateViewContentRequest
  ): zio.aws.connect.model.UpdateViewContentRequest.ReadOnly = new Wrapper(impl)
}
