package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  ViewDescription,
  ViewName,
  ViewId,
  ViewsInstanceId
}
import scala.jdk.CollectionConverters._
final case class UpdateViewMetadataRequest(
    instanceId: ViewsInstanceId,
    viewId: ViewId,
    name: Optional[ViewName] = Optional.Absent,
    description: Optional[ViewDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateViewMetadataRequest = {
    import UpdateViewMetadataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateViewMetadataRequest
      .builder()
      .instanceId(ViewsInstanceId.unwrap(instanceId): java.lang.String)
      .viewId(ViewId.unwrap(viewId): java.lang.String)
      .optionallyWith(
        name.map(value => ViewName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          ViewDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UpdateViewMetadataRequest.ReadOnly =
    zio.aws.connect.model.UpdateViewMetadataRequest.wrap(buildAwsValue())
}
object UpdateViewMetadataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateViewMetadataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateViewMetadataRequest =
      zio.aws.connect.model.UpdateViewMetadataRequest(
        instanceId,
        viewId,
        name.map(value => value),
        description.map(value => value)
      )
    def instanceId: ViewsInstanceId
    def viewId: ViewId
    def name: Optional[ViewName]
    def description: Optional[ViewDescription]
    def getInstanceId: ZIO[Any, Nothing, ViewsInstanceId] =
      ZIO.succeed(instanceId)
    def getViewId: ZIO[Any, Nothing, ViewId] = ZIO.succeed(viewId)
    def getName: ZIO[Any, AwsError, ViewName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, ViewDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateViewMetadataRequest
  ) extends zio.aws.connect.model.UpdateViewMetadataRequest.ReadOnly {
    override val instanceId: ViewsInstanceId =
      zio.aws.connect.model.primitives.ViewsInstanceId(impl.instanceId())
    override val viewId: ViewId =
      zio.aws.connect.model.primitives.ViewId(impl.viewId())
    override val name: Optional[ViewName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connect.model.primitives.ViewName(value))
    override val description: Optional[ViewDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.connect.model.primitives.ViewDescription(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateViewMetadataRequest
  ): zio.aws.connect.model.UpdateViewMetadataRequest.ReadOnly = new Wrapper(
    impl
  )
}
