package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait UseCaseType {
  def unwrap: software.amazon.awssdk.services.connect.model.UseCaseType
}
object UseCaseType {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.UseCaseType
  ): zio.aws.connect.model.UseCaseType = value match {
    case software.amazon.awssdk.services.connect.model.UseCaseType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.UseCaseType.RULES_EVALUATION =>
      val r = RULES_EVALUATION
      r
    case software.amazon.awssdk.services.connect.model.UseCaseType.CONNECT_CAMPAIGNS =>
      val r = CONNECT_CAMPAIGNS
      r
  }
  case object unknownToSdkVersion extends zio.aws.connect.model.UseCaseType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.UseCaseType =
      software.amazon.awssdk.services.connect.model.UseCaseType.UNKNOWN_TO_SDK_VERSION
  }
  case object RULES_EVALUATION extends zio.aws.connect.model.UseCaseType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.UseCaseType =
      software.amazon.awssdk.services.connect.model.UseCaseType.RULES_EVALUATION
  }
  case object CONNECT_CAMPAIGNS extends zio.aws.connect.model.UseCaseType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.UseCaseType =
      software.amazon.awssdk.services.connect.model.UseCaseType.CONNECT_CAMPAIGNS
  }
}
