package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  RoutingProfileId,
  UserId,
  TagValue,
  DirectoryUserId,
  HierarchyGroupId,
  AgentUsername,
  ARN,
  TagKey,
  SecurityProfileId
}
import scala.jdk.CollectionConverters._
final case class User(
    id: Optional[UserId] = Optional.Absent,
    arn: Optional[ARN] = Optional.Absent,
    username: Optional[AgentUsername] = Optional.Absent,
    identityInfo: Optional[zio.aws.connect.model.UserIdentityInfo] =
      Optional.Absent,
    phoneConfig: Optional[zio.aws.connect.model.UserPhoneConfig] =
      Optional.Absent,
    directoryUserId: Optional[DirectoryUserId] = Optional.Absent,
    securityProfileIds: Optional[Iterable[SecurityProfileId]] = Optional.Absent,
    routingProfileId: Optional[RoutingProfileId] = Optional.Absent,
    hierarchyGroupId: Optional[HierarchyGroupId] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.connect.model.User = {
    import User.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.User
      .builder()
      .optionallyWith(id.map(value => UserId.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        username.map(value => AgentUsername.unwrap(value): java.lang.String)
      )(_.username)
      .optionallyWith(identityInfo.map(value => value.buildAwsValue()))(
        _.identityInfo
      )
      .optionallyWith(phoneConfig.map(value => value.buildAwsValue()))(
        _.phoneConfig
      )
      .optionallyWith(
        directoryUserId.map(value =>
          DirectoryUserId.unwrap(value): java.lang.String
        )
      )(_.directoryUserId)
      .optionallyWith(
        securityProfileIds.map(value =>
          value.map { item =>
            SecurityProfileId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityProfileIds)
      .optionallyWith(
        routingProfileId.map(value =>
          RoutingProfileId.unwrap(value): java.lang.String
        )
      )(_.routingProfileId)
      .optionallyWith(
        hierarchyGroupId.map(value =>
          HierarchyGroupId.unwrap(value): java.lang.String
        )
      )(_.hierarchyGroupId)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.User.ReadOnly =
    zio.aws.connect.model.User.wrap(buildAwsValue())
}
object User {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.connect.model.User] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.User = zio.aws.connect.model.User(
      id.map(value => value),
      arn.map(value => value),
      username.map(value => value),
      identityInfo.map(value => value.asEditable),
      phoneConfig.map(value => value.asEditable),
      directoryUserId.map(value => value),
      securityProfileIds.map(value => value),
      routingProfileId.map(value => value),
      hierarchyGroupId.map(value => value),
      tags.map(value => value)
    )
    def id: Optional[UserId]
    def arn: Optional[ARN]
    def username: Optional[AgentUsername]
    def identityInfo: Optional[zio.aws.connect.model.UserIdentityInfo.ReadOnly]
    def phoneConfig: Optional[zio.aws.connect.model.UserPhoneConfig.ReadOnly]
    def directoryUserId: Optional[DirectoryUserId]
    def securityProfileIds: Optional[List[SecurityProfileId]]
    def routingProfileId: Optional[RoutingProfileId]
    def hierarchyGroupId: Optional[HierarchyGroupId]
    def tags: Optional[Map[TagKey, TagValue]]
    def getId: ZIO[Any, AwsError, UserId] = AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getUsername: ZIO[Any, AwsError, AgentUsername] =
      AwsError.unwrapOptionField("username", username)
    def getIdentityInfo
        : ZIO[Any, AwsError, zio.aws.connect.model.UserIdentityInfo.ReadOnly] =
      AwsError.unwrapOptionField("identityInfo", identityInfo)
    def getPhoneConfig
        : ZIO[Any, AwsError, zio.aws.connect.model.UserPhoneConfig.ReadOnly] =
      AwsError.unwrapOptionField("phoneConfig", phoneConfig)
    def getDirectoryUserId: ZIO[Any, AwsError, DirectoryUserId] =
      AwsError.unwrapOptionField("directoryUserId", directoryUserId)
    def getSecurityProfileIds: ZIO[Any, AwsError, List[SecurityProfileId]] =
      AwsError.unwrapOptionField("securityProfileIds", securityProfileIds)
    def getRoutingProfileId: ZIO[Any, AwsError, RoutingProfileId] =
      AwsError.unwrapOptionField("routingProfileId", routingProfileId)
    def getHierarchyGroupId: ZIO[Any, AwsError, HierarchyGroupId] =
      AwsError.unwrapOptionField("hierarchyGroupId", hierarchyGroupId)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.User
  ) extends zio.aws.connect.model.User.ReadOnly {
    override val id: Optional[UserId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.connect.model.primitives.UserId(value))
    override val arn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val username: Optional[AgentUsername] = zio.aws.core.internal
      .optionalFromNullable(impl.username())
      .map(value => zio.aws.connect.model.primitives.AgentUsername(value))
    override val identityInfo
        : Optional[zio.aws.connect.model.UserIdentityInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityInfo())
        .map(value => zio.aws.connect.model.UserIdentityInfo.wrap(value))
    override val phoneConfig
        : Optional[zio.aws.connect.model.UserPhoneConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneConfig())
        .map(value => zio.aws.connect.model.UserPhoneConfig.wrap(value))
    override val directoryUserId: Optional[DirectoryUserId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.directoryUserId())
        .map(value => zio.aws.connect.model.primitives.DirectoryUserId(value))
    override val securityProfileIds: Optional[List[SecurityProfileId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityProfileIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.primitives.SecurityProfileId(item)
          }.toList
        )
    override val routingProfileId: Optional[RoutingProfileId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routingProfileId())
        .map(value => zio.aws.connect.model.primitives.RoutingProfileId(value))
    override val hierarchyGroupId: Optional[HierarchyGroupId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hierarchyGroupId())
        .map(value => zio.aws.connect.model.primitives.HierarchyGroupId(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.User
  ): zio.aws.connect.model.User.ReadOnly = new Wrapper(impl)
}
