package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  HierarchyGroupId,
  UserId,
  RoutingProfileId,
  QueueId
}
import scala.jdk.CollectionConverters._
final case class UserDataFilters(
    queues: Optional[Iterable[QueueId]] = Optional.Absent,
    contactFilter: Optional[zio.aws.connect.model.ContactFilter] =
      Optional.Absent,
    routingProfiles: Optional[Iterable[RoutingProfileId]] = Optional.Absent,
    agents: Optional[Iterable[UserId]] = Optional.Absent,
    userHierarchyGroups: Optional[Iterable[HierarchyGroupId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UserDataFilters = {
    import UserDataFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UserDataFilters
      .builder()
      .optionallyWith(
        queues.map(value =>
          value.map { item =>
            QueueId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.queues)
      .optionallyWith(contactFilter.map(value => value.buildAwsValue()))(
        _.contactFilter
      )
      .optionallyWith(
        routingProfiles.map(value =>
          value.map { item =>
            RoutingProfileId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.routingProfiles)
      .optionallyWith(
        agents.map(value =>
          value.map { item =>
            UserId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.agents)
      .optionallyWith(
        userHierarchyGroups.map(value =>
          value.map { item =>
            HierarchyGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userHierarchyGroups)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UserDataFilters.ReadOnly =
    zio.aws.connect.model.UserDataFilters.wrap(buildAwsValue())
}
object UserDataFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UserDataFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UserDataFilters =
      zio.aws.connect.model.UserDataFilters(
        queues.map(value => value),
        contactFilter.map(value => value.asEditable),
        routingProfiles.map(value => value),
        agents.map(value => value),
        userHierarchyGroups.map(value => value)
      )
    def queues: Optional[List[QueueId]]
    def contactFilter: Optional[zio.aws.connect.model.ContactFilter.ReadOnly]
    def routingProfiles: Optional[List[RoutingProfileId]]
    def agents: Optional[List[UserId]]
    def userHierarchyGroups: Optional[List[HierarchyGroupId]]
    def getQueues: ZIO[Any, AwsError, List[QueueId]] =
      AwsError.unwrapOptionField("queues", queues)
    def getContactFilter
        : ZIO[Any, AwsError, zio.aws.connect.model.ContactFilter.ReadOnly] =
      AwsError.unwrapOptionField("contactFilter", contactFilter)
    def getRoutingProfiles: ZIO[Any, AwsError, List[RoutingProfileId]] =
      AwsError.unwrapOptionField("routingProfiles", routingProfiles)
    def getAgents: ZIO[Any, AwsError, List[UserId]] =
      AwsError.unwrapOptionField("agents", agents)
    def getUserHierarchyGroups: ZIO[Any, AwsError, List[HierarchyGroupId]] =
      AwsError.unwrapOptionField("userHierarchyGroups", userHierarchyGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UserDataFilters
  ) extends zio.aws.connect.model.UserDataFilters.ReadOnly {
    override val queues: Optional[List[QueueId]] = zio.aws.core.internal
      .optionalFromNullable(impl.queues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.primitives.QueueId(item)
        }.toList
      )
    override val contactFilter
        : Optional[zio.aws.connect.model.ContactFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contactFilter())
        .map(value => zio.aws.connect.model.ContactFilter.wrap(value))
    override val routingProfiles: Optional[List[RoutingProfileId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routingProfiles())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.primitives.RoutingProfileId(item)
          }.toList
        )
    override val agents: Optional[List[UserId]] = zio.aws.core.internal
      .optionalFromNullable(impl.agents())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.primitives.UserId(item)
        }.toList
      )
    override val userHierarchyGroups: Optional[List[HierarchyGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userHierarchyGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.primitives.HierarchyGroupId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UserDataFilters
  ): zio.aws.connect.model.UserDataFilters.ReadOnly = new Wrapper(impl)
}
