package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  PhoneNumber,
  Email,
  AgentLastName,
  AgentFirstName
}
import scala.jdk.CollectionConverters._
final case class UserIdentityInfo(
    firstName: Optional[AgentFirstName] = Optional.Absent,
    lastName: Optional[AgentLastName] = Optional.Absent,
    email: Optional[Email] = Optional.Absent,
    secondaryEmail: Optional[Email] = Optional.Absent,
    mobile: Optional[PhoneNumber] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UserIdentityInfo = {
    import UserIdentityInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UserIdentityInfo
      .builder()
      .optionallyWith(
        firstName.map(value => AgentFirstName.unwrap(value): java.lang.String)
      )(_.firstName)
      .optionallyWith(
        lastName.map(value => AgentLastName.unwrap(value): java.lang.String)
      )(_.lastName)
      .optionallyWith(
        email.map(value => Email.unwrap(value): java.lang.String)
      )(_.email)
      .optionallyWith(
        secondaryEmail.map(value => Email.unwrap(value): java.lang.String)
      )(_.secondaryEmail)
      .optionallyWith(
        mobile.map(value => PhoneNumber.unwrap(value): java.lang.String)
      )(_.mobile)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UserIdentityInfo.ReadOnly =
    zio.aws.connect.model.UserIdentityInfo.wrap(buildAwsValue())
}
object UserIdentityInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UserIdentityInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UserIdentityInfo =
      zio.aws.connect.model.UserIdentityInfo(
        firstName.map(value => value),
        lastName.map(value => value),
        email.map(value => value),
        secondaryEmail.map(value => value),
        mobile.map(value => value)
      )
    def firstName: Optional[AgentFirstName]
    def lastName: Optional[AgentLastName]
    def email: Optional[Email]
    def secondaryEmail: Optional[Email]
    def mobile: Optional[PhoneNumber]
    def getFirstName: ZIO[Any, AwsError, AgentFirstName] =
      AwsError.unwrapOptionField("firstName", firstName)
    def getLastName: ZIO[Any, AwsError, AgentLastName] =
      AwsError.unwrapOptionField("lastName", lastName)
    def getEmail: ZIO[Any, AwsError, Email] =
      AwsError.unwrapOptionField("email", email)
    def getSecondaryEmail: ZIO[Any, AwsError, Email] =
      AwsError.unwrapOptionField("secondaryEmail", secondaryEmail)
    def getMobile: ZIO[Any, AwsError, PhoneNumber] =
      AwsError.unwrapOptionField("mobile", mobile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UserIdentityInfo
  ) extends zio.aws.connect.model.UserIdentityInfo.ReadOnly {
    override val firstName: Optional[AgentFirstName] = zio.aws.core.internal
      .optionalFromNullable(impl.firstName())
      .map(value => zio.aws.connect.model.primitives.AgentFirstName(value))
    override val lastName: Optional[AgentLastName] = zio.aws.core.internal
      .optionalFromNullable(impl.lastName())
      .map(value => zio.aws.connect.model.primitives.AgentLastName(value))
    override val email: Optional[Email] = zio.aws.core.internal
      .optionalFromNullable(impl.email())
      .map(value => zio.aws.connect.model.primitives.Email(value))
    override val secondaryEmail: Optional[Email] = zio.aws.core.internal
      .optionalFromNullable(impl.secondaryEmail())
      .map(value => zio.aws.connect.model.primitives.Email(value))
    override val mobile: Optional[PhoneNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.mobile())
      .map(value => zio.aws.connect.model.primitives.PhoneNumber(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UserIdentityInfo
  ): zio.aws.connect.model.UserIdentityInfo.ReadOnly = new Wrapper(impl)
}
