package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{ContactFlowId, UserId}
import scala.jdk.CollectionConverters._
final case class UserQuickConnectConfig(
    userId: UserId,
    contactFlowId: ContactFlowId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UserQuickConnectConfig = {
    import UserQuickConnectConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UserQuickConnectConfig
      .builder()
      .userId(UserId.unwrap(userId): java.lang.String)
      .contactFlowId(ContactFlowId.unwrap(contactFlowId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UserQuickConnectConfig.ReadOnly =
    zio.aws.connect.model.UserQuickConnectConfig.wrap(buildAwsValue())
}
object UserQuickConnectConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UserQuickConnectConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UserQuickConnectConfig =
      zio.aws.connect.model.UserQuickConnectConfig(userId, contactFlowId)
    def userId: UserId
    def contactFlowId: ContactFlowId
    def getUserId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userId)
    def getContactFlowId: ZIO[Any, Nothing, ContactFlowId] =
      ZIO.succeed(contactFlowId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UserQuickConnectConfig
  ) extends zio.aws.connect.model.UserQuickConnectConfig.ReadOnly {
    override val userId: UserId =
      zio.aws.connect.model.primitives.UserId(impl.userId())
    override val contactFlowId: ContactFlowId =
      zio.aws.connect.model.primitives.ContactFlowId(impl.contactFlowId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UserQuickConnectConfig
  ): zio.aws.connect.model.UserQuickConnectConfig.ReadOnly = new Wrapper(impl)
}
