package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  Timestamp,
  ViewId,
  TagValue,
  ViewContentSha256,
  ViewName,
  ViewVersion,
  ViewDescription,
  ARN,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class View(
    id: Optional[ViewId] = Optional.Absent,
    arn: Optional[ARN] = Optional.Absent,
    name: Optional[ViewName] = Optional.Absent,
    status: Optional[zio.aws.connect.model.ViewStatus] = Optional.Absent,
    `type`: Optional[zio.aws.connect.model.ViewType] = Optional.Absent,
    description: Optional[ViewDescription] = Optional.Absent,
    version: Optional[ViewVersion] = Optional.Absent,
    versionDescription: Optional[ViewDescription] = Optional.Absent,
    content: Optional[zio.aws.connect.model.ViewContent] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    createdTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    viewContentSha256: Optional[ViewContentSha256] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.connect.model.View = {
    import View.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.View
      .builder()
      .optionallyWith(id.map(value => ViewId.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        name.map(value => ViewName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        description.map(value =>
          ViewDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(version.map(value => ViewVersion.unwrap(value): Integer))(
        _.version
      )
      .optionallyWith(
        versionDescription.map(value =>
          ViewDescription.unwrap(value): java.lang.String
        )
      )(_.versionDescription)
      .optionallyWith(content.map(value => value.buildAwsValue()))(_.content)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        viewContentSha256.map(value =>
          ViewContentSha256.unwrap(value): java.lang.String
        )
      )(_.viewContentSha256)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.View.ReadOnly =
    zio.aws.connect.model.View.wrap(buildAwsValue())
}
object View {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.connect.model.View] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.View = zio.aws.connect.model.View(
      id.map(value => value),
      arn.map(value => value),
      name.map(value => value),
      status.map(value => value),
      `type`.map(value => value),
      description.map(value => value),
      version.map(value => value),
      versionDescription.map(value => value),
      content.map(value => value.asEditable),
      tags.map(value => value),
      createdTime.map(value => value),
      lastModifiedTime.map(value => value),
      viewContentSha256.map(value => value)
    )
    def id: Optional[ViewId]
    def arn: Optional[ARN]
    def name: Optional[ViewName]
    def status: Optional[zio.aws.connect.model.ViewStatus]
    def `type`: Optional[zio.aws.connect.model.ViewType]
    def description: Optional[ViewDescription]
    def version: Optional[ViewVersion]
    def versionDescription: Optional[ViewDescription]
    def content: Optional[zio.aws.connect.model.ViewContent.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def createdTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def viewContentSha256: Optional[ViewContentSha256]
    def getId: ZIO[Any, AwsError, ViewId] = AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, ViewName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, zio.aws.connect.model.ViewStatus] =
      AwsError.unwrapOptionField("status", status)
    def getType: ZIO[Any, AwsError, zio.aws.connect.model.ViewType] =
      AwsError.unwrapOptionField("type", `type`)
    def getDescription: ZIO[Any, AwsError, ViewDescription] =
      AwsError.unwrapOptionField("description", description)
    def getVersion: ZIO[Any, AwsError, ViewVersion] =
      AwsError.unwrapOptionField("version", version)
    def getVersionDescription: ZIO[Any, AwsError, ViewDescription] =
      AwsError.unwrapOptionField("versionDescription", versionDescription)
    def getContent
        : ZIO[Any, AwsError, zio.aws.connect.model.ViewContent.ReadOnly] =
      AwsError.unwrapOptionField("content", content)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getViewContentSha256: ZIO[Any, AwsError, ViewContentSha256] =
      AwsError.unwrapOptionField("viewContentSha256", viewContentSha256)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.View
  ) extends zio.aws.connect.model.View.ReadOnly {
    override val id: Optional[ViewId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.connect.model.primitives.ViewId(value))
    override val arn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val name: Optional[ViewName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connect.model.primitives.ViewName(value))
    override val status: Optional[zio.aws.connect.model.ViewStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.connect.model.ViewStatus.wrap(value))
    override val `type`: Optional[zio.aws.connect.model.ViewType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.connect.model.ViewType.wrap(value))
    override val description: Optional[ViewDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.connect.model.primitives.ViewDescription(value))
    override val version: Optional[ViewVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.connect.model.primitives.ViewVersion(value))
    override val versionDescription: Optional[ViewDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionDescription())
        .map(value => zio.aws.connect.model.primitives.ViewDescription(value))
    override val content: Optional[zio.aws.connect.model.ViewContent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.content())
        .map(value => zio.aws.connect.model.ViewContent.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val createdTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.connect.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.connect.model.primitives.Timestamp(value))
    override val viewContentSha256: Optional[ViewContentSha256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.viewContentSha256())
        .map(value => zio.aws.connect.model.primitives.ViewContentSha256(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.View
  ): zio.aws.connect.model.View.ReadOnly = new Wrapper(impl)
}
