package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  ViewAction,
  ViewTemplate,
  ViewInputSchema
}
import scala.jdk.CollectionConverters._
final case class ViewContent(
    inputSchema: Optional[ViewInputSchema] = Optional.Absent,
    template: Optional[ViewTemplate] = Optional.Absent,
    actions: Optional[Iterable[ViewAction]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ViewContent = {
    import ViewContent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ViewContent
      .builder()
      .optionallyWith(
        inputSchema.map(value =>
          ViewInputSchema.unwrap(value): java.lang.String
        )
      )(_.inputSchema)
      .optionallyWith(
        template.map(value => ViewTemplate.unwrap(value): java.lang.String)
      )(_.template)
      .optionallyWith(
        actions.map(value =>
          value.map { item =>
            ViewAction.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.actions)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ViewContent.ReadOnly =
    zio.aws.connect.model.ViewContent.wrap(buildAwsValue())
}
object ViewContent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ViewContent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ViewContent =
      zio.aws.connect.model.ViewContent(
        inputSchema.map(value => value),
        template.map(value => value),
        actions.map(value => value)
      )
    def inputSchema: Optional[ViewInputSchema]
    def template: Optional[ViewTemplate]
    def actions: Optional[List[ViewAction]]
    def getInputSchema: ZIO[Any, AwsError, ViewInputSchema] =
      AwsError.unwrapOptionField("inputSchema", inputSchema)
    def getTemplate: ZIO[Any, AwsError, ViewTemplate] =
      AwsError.unwrapOptionField("template", template)
    def getActions: ZIO[Any, AwsError, List[ViewAction]] =
      AwsError.unwrapOptionField("actions", actions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ViewContent
  ) extends zio.aws.connect.model.ViewContent.ReadOnly {
    override val inputSchema: Optional[ViewInputSchema] = zio.aws.core.internal
      .optionalFromNullable(impl.inputSchema())
      .map(value => zio.aws.connect.model.primitives.ViewInputSchema(value))
    override val template: Optional[ViewTemplate] = zio.aws.core.internal
      .optionalFromNullable(impl.template())
      .map(value => zio.aws.connect.model.primitives.ViewTemplate(value))
    override val actions: Optional[List[ViewAction]] = zio.aws.core.internal
      .optionalFromNullable(impl.actions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.primitives.ViewAction(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ViewContent
  ): zio.aws.connect.model.ViewContent.ReadOnly = new Wrapper(impl)
}
