package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{ViewAction, ViewTemplate}
import scala.jdk.CollectionConverters._
final case class ViewInputContent(
    template: Optional[ViewTemplate] = Optional.Absent,
    actions: Optional[Iterable[ViewAction]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ViewInputContent = {
    import ViewInputContent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ViewInputContent
      .builder()
      .optionallyWith(
        template.map(value => ViewTemplate.unwrap(value): java.lang.String)
      )(_.template)
      .optionallyWith(
        actions.map(value =>
          value.map { item =>
            ViewAction.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.actions)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ViewInputContent.ReadOnly =
    zio.aws.connect.model.ViewInputContent.wrap(buildAwsValue())
}
object ViewInputContent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ViewInputContent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ViewInputContent =
      zio.aws.connect.model.ViewInputContent(
        template.map(value => value),
        actions.map(value => value)
      )
    def template: Optional[ViewTemplate]
    def actions: Optional[List[ViewAction]]
    def getTemplate: ZIO[Any, AwsError, ViewTemplate] =
      AwsError.unwrapOptionField("template", template)
    def getActions: ZIO[Any, AwsError, List[ViewAction]] =
      AwsError.unwrapOptionField("actions", actions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ViewInputContent
  ) extends zio.aws.connect.model.ViewInputContent.ReadOnly {
    override val template: Optional[ViewTemplate] = zio.aws.core.internal
      .optionalFromNullable(impl.template())
      .map(value => zio.aws.connect.model.primitives.ViewTemplate(value))
    override val actions: Optional[List[ViewAction]] = zio.aws.core.internal
      .optionalFromNullable(impl.actions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.primitives.ViewAction(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ViewInputContent
  ): zio.aws.connect.model.ViewInputContent.ReadOnly = new Wrapper(impl)
}
