package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{ViewDescription, ViewName, ARN, ViewId}
import scala.jdk.CollectionConverters._
final case class ViewSummary(
    id: Optional[ViewId] = Optional.Absent,
    arn: Optional[ARN] = Optional.Absent,
    name: Optional[ViewName] = Optional.Absent,
    `type`: Optional[zio.aws.connect.model.ViewType] = Optional.Absent,
    status: Optional[zio.aws.connect.model.ViewStatus] = Optional.Absent,
    description: Optional[ViewDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ViewSummary = {
    import ViewSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ViewSummary
      .builder()
      .optionallyWith(id.map(value => ViewId.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        name.map(value => ViewName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        description.map(value =>
          ViewDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ViewSummary.ReadOnly =
    zio.aws.connect.model.ViewSummary.wrap(buildAwsValue())
}
object ViewSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ViewSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ViewSummary =
      zio.aws.connect.model.ViewSummary(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value),
        `type`.map(value => value),
        status.map(value => value),
        description.map(value => value)
      )
    def id: Optional[ViewId]
    def arn: Optional[ARN]
    def name: Optional[ViewName]
    def `type`: Optional[zio.aws.connect.model.ViewType]
    def status: Optional[zio.aws.connect.model.ViewStatus]
    def description: Optional[ViewDescription]
    def getId: ZIO[Any, AwsError, ViewId] = AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, ViewName] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, zio.aws.connect.model.ViewType] =
      AwsError.unwrapOptionField("type", `type`)
    def getStatus: ZIO[Any, AwsError, zio.aws.connect.model.ViewStatus] =
      AwsError.unwrapOptionField("status", status)
    def getDescription: ZIO[Any, AwsError, ViewDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ViewSummary
  ) extends zio.aws.connect.model.ViewSummary.ReadOnly {
    override val id: Optional[ViewId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.connect.model.primitives.ViewId(value))
    override val arn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val name: Optional[ViewName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connect.model.primitives.ViewName(value))
    override val `type`: Optional[zio.aws.connect.model.ViewType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.connect.model.ViewType.wrap(value))
    override val status: Optional[zio.aws.connect.model.ViewStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.connect.model.ViewStatus.wrap(value))
    override val description: Optional[ViewDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.connect.model.primitives.ViewDescription(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ViewSummary
  ): zio.aws.connect.model.ViewSummary.ReadOnly = new Wrapper(impl)
}
