package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait ViewType {
  def unwrap: software.amazon.awssdk.services.connect.model.ViewType
}
object ViewType {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.ViewType
  ): zio.aws.connect.model.ViewType = value match {
    case software.amazon.awssdk.services.connect.model.ViewType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.ViewType.CUSTOMER_MANAGED =>
      val r = CUSTOMER_MANAGED
      r
    case software.amazon.awssdk.services.connect.model.ViewType.AWS_MANAGED =>
      val r = AWS_MANAGED
      r
  }
  case object unknownToSdkVersion extends zio.aws.connect.model.ViewType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ViewType =
      software.amazon.awssdk.services.connect.model.ViewType.UNKNOWN_TO_SDK_VERSION
  }
  case object CUSTOMER_MANAGED extends zio.aws.connect.model.ViewType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ViewType =
      software.amazon.awssdk.services.connect.model.ViewType.CUSTOMER_MANAGED
  }
  case object AWS_MANAGED extends zio.aws.connect.model.ViewType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ViewType =
      software.amazon.awssdk.services.connect.model.ViewType.AWS_MANAGED
  }
}
