package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  ViewId,
  ViewName,
  ViewVersion,
  ViewDescription,
  ARN
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ViewVersionSummary(
    id: Optional[ViewId] = Optional.Absent,
    arn: Optional[ARN] = Optional.Absent,
    description: Optional[ViewDescription] = Optional.Absent,
    name: Optional[ViewName] = Optional.Absent,
    `type`: Optional[zio.aws.connect.model.ViewType] = Optional.Absent,
    version: Optional[ViewVersion] = Optional.Absent,
    versionDescription: Optional[ViewDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ViewVersionSummary = {
    import ViewVersionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ViewVersionSummary
      .builder()
      .optionallyWith(id.map(value => ViewId.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        description.map(value =>
          ViewDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        name.map(value => ViewName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(version.map(value => ViewVersion.unwrap(value): Integer))(
        _.version
      )
      .optionallyWith(
        versionDescription.map(value =>
          ViewDescription.unwrap(value): java.lang.String
        )
      )(_.versionDescription)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ViewVersionSummary.ReadOnly =
    zio.aws.connect.model.ViewVersionSummary.wrap(buildAwsValue())
}
object ViewVersionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ViewVersionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ViewVersionSummary =
      zio.aws.connect.model.ViewVersionSummary(
        id.map(value => value),
        arn.map(value => value),
        description.map(value => value),
        name.map(value => value),
        `type`.map(value => value),
        version.map(value => value),
        versionDescription.map(value => value)
      )
    def id: Optional[ViewId]
    def arn: Optional[ARN]
    def description: Optional[ViewDescription]
    def name: Optional[ViewName]
    def `type`: Optional[zio.aws.connect.model.ViewType]
    def version: Optional[ViewVersion]
    def versionDescription: Optional[ViewDescription]
    def getId: ZIO[Any, AwsError, ViewId] = AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getDescription: ZIO[Any, AwsError, ViewDescription] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, AwsError, ViewName] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, zio.aws.connect.model.ViewType] =
      AwsError.unwrapOptionField("type", `type`)
    def getVersion: ZIO[Any, AwsError, ViewVersion] =
      AwsError.unwrapOptionField("version", version)
    def getVersionDescription: ZIO[Any, AwsError, ViewDescription] =
      AwsError.unwrapOptionField("versionDescription", versionDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ViewVersionSummary
  ) extends zio.aws.connect.model.ViewVersionSummary.ReadOnly {
    override val id: Optional[ViewId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.connect.model.primitives.ViewId(value))
    override val arn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val description: Optional[ViewDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.connect.model.primitives.ViewDescription(value))
    override val name: Optional[ViewName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connect.model.primitives.ViewName(value))
    override val `type`: Optional[zio.aws.connect.model.ViewType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.connect.model.ViewType.wrap(value))
    override val version: Optional[ViewVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.connect.model.primitives.ViewVersion(value))
    override val versionDescription: Optional[ViewDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionDescription())
        .map(value => zio.aws.connect.model.primitives.ViewDescription(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ViewVersionSummary
  ): zio.aws.connect.model.ViewVersionSummary.ReadOnly = new Wrapper(impl)
}
