package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  VocabularyId,
  VocabularyLastModifiedTime,
  VocabularyName,
  VocabularyFailureReason,
  ARN
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class VocabularySummary(
    name: VocabularyName,
    id: VocabularyId,
    arn: ARN,
    languageCode: zio.aws.connect.model.VocabularyLanguageCode,
    state: zio.aws.connect.model.VocabularyState,
    lastModifiedTime: VocabularyLastModifiedTime,
    failureReason: Optional[VocabularyFailureReason] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.VocabularySummary = {
    import VocabularySummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.VocabularySummary
      .builder()
      .name(VocabularyName.unwrap(name): java.lang.String)
      .id(VocabularyId.unwrap(id): java.lang.String)
      .arn(ARN.unwrap(arn): java.lang.String)
      .languageCode(languageCode.unwrap)
      .state(state.unwrap)
      .lastModifiedTime(
        VocabularyLastModifiedTime.unwrap(lastModifiedTime): Instant
      )
      .optionallyWith(
        failureReason.map(value =>
          VocabularyFailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.VocabularySummary.ReadOnly =
    zio.aws.connect.model.VocabularySummary.wrap(buildAwsValue())
}
object VocabularySummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.VocabularySummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.VocabularySummary =
      zio.aws.connect.model.VocabularySummary(
        name,
        id,
        arn,
        languageCode,
        state,
        lastModifiedTime,
        failureReason.map(value => value)
      )
    def name: VocabularyName
    def id: VocabularyId
    def arn: ARN
    def languageCode: zio.aws.connect.model.VocabularyLanguageCode
    def state: zio.aws.connect.model.VocabularyState
    def lastModifiedTime: VocabularyLastModifiedTime
    def failureReason: Optional[VocabularyFailureReason]
    def getName: ZIO[Any, Nothing, VocabularyName] = ZIO.succeed(name)
    def getId: ZIO[Any, Nothing, VocabularyId] = ZIO.succeed(id)
    def getArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(arn)
    def getLanguageCode
        : ZIO[Any, Nothing, zio.aws.connect.model.VocabularyLanguageCode] =
      ZIO.succeed(languageCode)
    def getState: ZIO[Any, Nothing, zio.aws.connect.model.VocabularyState] =
      ZIO.succeed(state)
    def getLastModifiedTime: ZIO[Any, Nothing, VocabularyLastModifiedTime] =
      ZIO.succeed(lastModifiedTime)
    def getFailureReason: ZIO[Any, AwsError, VocabularyFailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.VocabularySummary
  ) extends zio.aws.connect.model.VocabularySummary.ReadOnly {
    override val name: VocabularyName =
      zio.aws.connect.model.primitives.VocabularyName(impl.name())
    override val id: VocabularyId =
      zio.aws.connect.model.primitives.VocabularyId(impl.id())
    override val arn: ARN = zio.aws.connect.model.primitives.ARN(impl.arn())
    override val languageCode: zio.aws.connect.model.VocabularyLanguageCode =
      zio.aws.connect.model.VocabularyLanguageCode.wrap(impl.languageCode())
    override val state: zio.aws.connect.model.VocabularyState =
      zio.aws.connect.model.VocabularyState.wrap(impl.state())
    override val lastModifiedTime: VocabularyLastModifiedTime =
      zio.aws.connect.model.primitives
        .VocabularyLastModifiedTime(impl.lastModifiedTime())
    override val failureReason: Optional[VocabularyFailureReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureReason())
        .map(value =>
          zio.aws.connect.model.primitives.VocabularyFailureReason(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.VocabularySummary
  ): zio.aws.connect.model.VocabularySummary.ReadOnly = new Wrapper(impl)
}
