package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class WisdomInfo(sessionArn: Optional[ARN] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.WisdomInfo = {
    import WisdomInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.WisdomInfo
      .builder()
      .optionallyWith(
        sessionArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.sessionArn)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.WisdomInfo.ReadOnly =
    zio.aws.connect.model.WisdomInfo.wrap(buildAwsValue())
}
object WisdomInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.WisdomInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.WisdomInfo =
      zio.aws.connect.model.WisdomInfo(sessionArn.map(value => value))
    def sessionArn: Optional[ARN]
    def getSessionArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("sessionArn", sessionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.WisdomInfo
  ) extends zio.aws.connect.model.WisdomInfo.ReadOnly {
    override val sessionArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionArn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.WisdomInfo
  ): zio.aws.connect.model.WisdomInfo.ReadOnly = new Wrapper(impl)
}
