package zio.aws.controltower
import zio.aws.core.config.AwsConfig
import zio.aws.controltower.model.DisableControlResponse.ReadOnly
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.controltower.model.{
  ListEnabledControlsRequest,
  GetControlOperationRequest,
  EnableControlRequest,
  DisableControlRequest
}
import software.amazon.awssdk.services.controltower.paginators.ListEnabledControlsPublisher
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.controltower.{
  ControlTowerAsyncClientBuilder,
  ControlTowerAsyncClient
}
import software.amazon.awssdk.services.controltower.model.{
  EnableControlResponse,
  GetControlOperationResponse,
  EnabledControlSummary,
  ListEnabledControlsResponse,
  DisableControlResponse
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait ControlTower extends AspectSupport[ControlTower] {
  val api: ControlTowerAsyncClient
  def disableControl(request: DisableControlRequest): IO[AwsError, ReadOnly]
  def enableControl(
      request: EnableControlRequest
  ): IO[AwsError, zio.aws.controltower.model.EnableControlResponse.ReadOnly]
  def getControlOperation(request: GetControlOperationRequest): IO[
    AwsError,
    zio.aws.controltower.model.GetControlOperationResponse.ReadOnly
  ]
  def listEnabledControls(request: ListEnabledControlsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.controltower.model.EnabledControlSummary.ReadOnly
  ]
  def listEnabledControlsPaginated(request: ListEnabledControlsRequest): IO[
    AwsError,
    zio.aws.controltower.model.ListEnabledControlsResponse.ReadOnly
  ]
}
object ControlTower {
  val live: ZLayer[AwsConfig, java.lang.Throwable, ControlTower] = customized(
    identity
  )
  def customized(
      customization: ControlTowerAsyncClientBuilder => ControlTowerAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, ControlTower] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: ControlTowerAsyncClientBuilder => ControlTowerAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, ControlTower] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = ControlTowerAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[ControlTowerAsyncClient, ControlTowerAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      ControlTowerAsyncClient,
      ControlTowerAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new ControlTowerImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class ControlTowerImpl[R](
      override val api: ControlTowerAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends ControlTower
      with AwsServiceBase[R] {
    override val serviceName: String = "ControlTower"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ControlTowerImpl[R1] = new ControlTowerImpl(api, newAspect, r)
    def disableControl(request: DisableControlRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.controltower.model.DisableControlRequest,
        DisableControlResponse
      ]("disableControl", api.disableControl)(request.buildAwsValue())
        .map(zio.aws.controltower.model.DisableControlResponse.wrap)
        .provideEnvironment(r)
    def enableControl(
        request: EnableControlRequest
    ): IO[AwsError, zio.aws.controltower.model.EnableControlResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.controltower.model.EnableControlRequest,
        EnableControlResponse
      ]("enableControl", api.enableControl)(request.buildAwsValue())
        .map(zio.aws.controltower.model.EnableControlResponse.wrap)
        .provideEnvironment(r)
    def getControlOperation(request: GetControlOperationRequest): IO[
      AwsError,
      zio.aws.controltower.model.GetControlOperationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.controltower.model.GetControlOperationRequest,
      GetControlOperationResponse
    ]("getControlOperation", api.getControlOperation)(request.buildAwsValue())
      .map(zio.aws.controltower.model.GetControlOperationResponse.wrap)
      .provideEnvironment(r)
    def listEnabledControls(request: ListEnabledControlsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.controltower.model.EnabledControlSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.controltower.model.ListEnabledControlsRequest,
      EnabledControlSummary,
      ListEnabledControlsPublisher
    ](
      "listEnabledControls",
      api.listEnabledControlsPaginator,
      _.enabledControls()
    )(request.buildAwsValue())
      .map(item => zio.aws.controltower.model.EnabledControlSummary.wrap(item))
      .provideEnvironment(r)
    def listEnabledControlsPaginated(request: ListEnabledControlsRequest): IO[
      AwsError,
      zio.aws.controltower.model.ListEnabledControlsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.controltower.model.ListEnabledControlsRequest,
      ListEnabledControlsResponse
    ]("listEnabledControls", api.listEnabledControls)(request.buildAwsValue())
      .map(zio.aws.controltower.model.ListEnabledControlsResponse.wrap)
      .provideEnvironment(r)
  }
  def disableControl(
      request: DisableControlRequest
  ): ZIO[zio.aws.controltower.ControlTower, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.disableControl(request))
  def enableControl(request: EnableControlRequest): ZIO[
    zio.aws.controltower.ControlTower,
    AwsError,
    zio.aws.controltower.model.EnableControlResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.enableControl(request))
  def getControlOperation(request: GetControlOperationRequest): ZIO[
    zio.aws.controltower.ControlTower,
    AwsError,
    zio.aws.controltower.model.GetControlOperationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getControlOperation(request))
  def listEnabledControls(request: ListEnabledControlsRequest): ZStream[
    zio.aws.controltower.ControlTower,
    AwsError,
    zio.aws.controltower.model.EnabledControlSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listEnabledControls(request))
  def listEnabledControlsPaginated(request: ListEnabledControlsRequest): ZIO[
    zio.aws.controltower.ControlTower,
    AwsError,
    zio.aws.controltower.model.ListEnabledControlsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEnabledControlsPaginated(request))
}
