package zio.aws.controltower
import zio.mock.{Proxy, Mock}
import zio.aws.controltower.model.DisableControlResponse.ReadOnly
import zio.aws.core.AwsError
import zio.aws.controltower.model.{
  ListEnabledControlsRequest,
  GetControlOperationRequest,
  EnableControlRequest,
  DisableControlRequest
}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.controltower.ControlTowerAsyncClient
import zio.stream.ZStream
object ControlTowerMock extends Mock[ControlTower] {
  object DisableControl
      extends Effect[DisableControlRequest, AwsError, ReadOnly]
  object EnableControl
      extends Effect[
        EnableControlRequest,
        AwsError,
        zio.aws.controltower.model.EnableControlResponse.ReadOnly
      ]
  object GetControlOperation
      extends Effect[
        GetControlOperationRequest,
        AwsError,
        zio.aws.controltower.model.GetControlOperationResponse.ReadOnly
      ]
  object ListEnabledControls
      extends Stream[
        ListEnabledControlsRequest,
        AwsError,
        zio.aws.controltower.model.EnabledControlSummary.ReadOnly
      ]
  object ListEnabledControlsPaginated
      extends Effect[
        ListEnabledControlsRequest,
        AwsError,
        zio.aws.controltower.model.ListEnabledControlsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, ControlTower] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, ControlTower] { rts =>
        zio.ZIO.succeed {
          new ControlTower {
            val api: ControlTowerAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): ControlTower = this
            def disableControl(
                request: DisableControlRequest
            ): IO[AwsError, ReadOnly] = proxy(DisableControl, request)
            def enableControl(request: EnableControlRequest): IO[
              AwsError,
              zio.aws.controltower.model.EnableControlResponse.ReadOnly
            ] = proxy(EnableControl, request)
            def getControlOperation(request: GetControlOperationRequest): IO[
              AwsError,
              zio.aws.controltower.model.GetControlOperationResponse.ReadOnly
            ] = proxy(GetControlOperation, request)
            def listEnabledControls(
                request: ListEnabledControlsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.controltower.model.EnabledControlSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEnabledControls, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEnabledControlsPaginated(
                request: ListEnabledControlsRequest
            ): IO[
              AwsError,
              zio.aws.controltower.model.ListEnabledControlsResponse.ReadOnly
            ] = proxy(ListEnabledControlsPaginated, request)
          }
        }
      }
    }
  }
}
