package zio.aws.controltower.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.controltower.model.primitives.SyntheticTimestamp_date_time
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ControlOperation(
    endTime: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    operationType: Optional[zio.aws.controltower.model.ControlOperationType] =
      Optional.Absent,
    startTime: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    status: Optional[zio.aws.controltower.model.ControlOperationStatus] =
      Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.controltower.model.ControlOperation = {
    import ControlOperation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.controltower.model.ControlOperation
      .builder()
      .optionallyWith(
        endTime.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.endTime)
      .optionallyWith(operationType.map(value => value.unwrap))(_.operationType)
      .optionallyWith(
        startTime.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.startTime)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.controltower.model.ControlOperation.ReadOnly =
    zio.aws.controltower.model.ControlOperation.wrap(buildAwsValue())
}
object ControlOperation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.controltower.model.ControlOperation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.controltower.model.ControlOperation =
      zio.aws.controltower.model.ControlOperation(
        endTime.map(value => value),
        operationType.map(value => value),
        startTime.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value)
      )
    def endTime: Optional[SyntheticTimestamp_date_time]
    def operationType: Optional[zio.aws.controltower.model.ControlOperationType]
    def startTime: Optional[SyntheticTimestamp_date_time]
    def status: Optional[zio.aws.controltower.model.ControlOperationStatus]
    def statusMessage: Optional[String]
    def getEndTime: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getOperationType
        : ZIO[Any, AwsError, zio.aws.controltower.model.ControlOperationType] =
      AwsError.unwrapOptionField("operationType", operationType)
    def getStartTime: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.controltower.model.ControlOperationStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.controltower.model.ControlOperation
  ) extends zio.aws.controltower.model.ControlOperation.ReadOnly {
    override val endTime: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endTime())
        .map(value =>
          zio.aws.controltower.model.primitives
            .SyntheticTimestamp_date_time(value)
        )
    override val operationType
        : Optional[zio.aws.controltower.model.ControlOperationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operationType())
        .map(value =>
          zio.aws.controltower.model.ControlOperationType.wrap(value)
        )
    override val startTime: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startTime())
        .map(value =>
          zio.aws.controltower.model.primitives
            .SyntheticTimestamp_date_time(value)
        )
    override val status
        : Optional[zio.aws.controltower.model.ControlOperationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.controltower.model.ControlOperationStatus.wrap(value)
        )
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.controltower.model.ControlOperation
  ): zio.aws.controltower.model.ControlOperation.ReadOnly = new Wrapper(impl)
}
