package zio.aws.controltower.model
import scala.jdk.CollectionConverters.*
sealed trait ControlOperationStatus {
  def unwrap: software.amazon.awssdk.services.controltower.model.ControlOperationStatus
}
object ControlOperationStatus {
  def wrap(
      value: software.amazon.awssdk.services.controltower.model.ControlOperationStatus
  ): zio.aws.controltower.model.ControlOperationStatus = value match {
    case software.amazon.awssdk.services.controltower.model.ControlOperationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.controltower.model.ControlOperationStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.controltower.model.ControlOperationStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.controltower.model.ControlOperationStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.controltower.model.ControlOperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.controltower.model.ControlOperationStatus =
      software.amazon.awssdk.services.controltower.model.ControlOperationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object SUCCEEDED
      extends zio.aws.controltower.model.ControlOperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.controltower.model.ControlOperationStatus =
      software.amazon.awssdk.services.controltower.model.ControlOperationStatus.SUCCEEDED
  }
  case object FAILED extends zio.aws.controltower.model.ControlOperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.controltower.model.ControlOperationStatus =
      software.amazon.awssdk.services.controltower.model.ControlOperationStatus.FAILED
  }
  case object IN_PROGRESS
      extends zio.aws.controltower.model.ControlOperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.controltower.model.ControlOperationStatus =
      software.amazon.awssdk.services.controltower.model.ControlOperationStatus.IN_PROGRESS
  }
}
