package zio.aws.controltower.model
import scala.jdk.CollectionConverters.*
sealed trait ControlOperationType {
  def unwrap
      : software.amazon.awssdk.services.controltower.model.ControlOperationType
}
object ControlOperationType {
  def wrap(
      value: software.amazon.awssdk.services.controltower.model.ControlOperationType
  ): zio.aws.controltower.model.ControlOperationType = value match {
    case software.amazon.awssdk.services.controltower.model.ControlOperationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.controltower.model.ControlOperationType.ENABLE_CONTROL =>
      val r = ENABLE_CONTROL
      r
    case software.amazon.awssdk.services.controltower.model.ControlOperationType.DISABLE_CONTROL =>
      val r = DISABLE_CONTROL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.controltower.model.ControlOperationType {
    override def unwrap
        : software.amazon.awssdk.services.controltower.model.ControlOperationType =
      software.amazon.awssdk.services.controltower.model.ControlOperationType.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLE_CONTROL
      extends zio.aws.controltower.model.ControlOperationType {
    override def unwrap
        : software.amazon.awssdk.services.controltower.model.ControlOperationType =
      software.amazon.awssdk.services.controltower.model.ControlOperationType.ENABLE_CONTROL
  }
  case object DISABLE_CONTROL
      extends zio.aws.controltower.model.ControlOperationType {
    override def unwrap
        : software.amazon.awssdk.services.controltower.model.ControlOperationType =
      software.amazon.awssdk.services.controltower.model.ControlOperationType.DISABLE_CONTROL
  }
}
