package zio.aws.controltower.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.controltower.model.primitives.{
  TargetIdentifier,
  ControlIdentifier
}
import scala.jdk.CollectionConverters.*
final case class DisableControlRequest(
    controlIdentifier: ControlIdentifier,
    targetIdentifier: TargetIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.controltower.model.DisableControlRequest = {
    import DisableControlRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.controltower.model.DisableControlRequest
      .builder()
      .controlIdentifier(
        ControlIdentifier.unwrap(controlIdentifier): java.lang.String
      )
      .targetIdentifier(
        TargetIdentifier.unwrap(targetIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.controltower.model.DisableControlRequest.ReadOnly =
    zio.aws.controltower.model.DisableControlRequest.wrap(buildAwsValue())
}
object DisableControlRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.controltower.model.DisableControlRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.controltower.model.DisableControlRequest =
      zio.aws.controltower.model
        .DisableControlRequest(controlIdentifier, targetIdentifier)
    def controlIdentifier: ControlIdentifier
    def targetIdentifier: TargetIdentifier
    def getControlIdentifier: ZIO[Any, Nothing, ControlIdentifier] =
      ZIO.succeed(controlIdentifier)
    def getTargetIdentifier: ZIO[Any, Nothing, TargetIdentifier] =
      ZIO.succeed(targetIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.controltower.model.DisableControlRequest
  ) extends zio.aws.controltower.model.DisableControlRequest.ReadOnly {
    override val controlIdentifier: ControlIdentifier =
      zio.aws.controltower.model.primitives
        .ControlIdentifier(impl.controlIdentifier())
    override val targetIdentifier: TargetIdentifier =
      zio.aws.controltower.model.primitives
        .TargetIdentifier(impl.targetIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.controltower.model.DisableControlRequest
  ): zio.aws.controltower.model.DisableControlRequest.ReadOnly = new Wrapper(
    impl
  )
}
