package zio.aws.controltower.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.controltower.model.primitives.OperationIdentifier
import scala.jdk.CollectionConverters.*
final case class DisableControlResponse(
    operationIdentifier: OperationIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.controltower.model.DisableControlResponse = {
    import DisableControlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.controltower.model.DisableControlResponse
      .builder()
      .operationIdentifier(
        OperationIdentifier.unwrap(operationIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.controltower.model.DisableControlResponse.ReadOnly =
    zio.aws.controltower.model.DisableControlResponse.wrap(buildAwsValue())
}
object DisableControlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.controltower.model.DisableControlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.controltower.model.DisableControlResponse =
      zio.aws.controltower.model.DisableControlResponse(operationIdentifier)
    def operationIdentifier: OperationIdentifier
    def getOperationIdentifier: ZIO[Any, Nothing, OperationIdentifier] =
      ZIO.succeed(operationIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.controltower.model.DisableControlResponse
  ) extends zio.aws.controltower.model.DisableControlResponse.ReadOnly {
    override val operationIdentifier: OperationIdentifier =
      zio.aws.controltower.model.primitives
        .OperationIdentifier(impl.operationIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.controltower.model.DisableControlResponse
  ): zio.aws.controltower.model.DisableControlResponse.ReadOnly = new Wrapper(
    impl
  )
}
