package zio.aws.controltower.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.controltower.model.primitives.{
  TargetIdentifier,
  ControlIdentifier
}
import scala.jdk.CollectionConverters.*
final case class EnableControlRequest(
    controlIdentifier: ControlIdentifier,
    targetIdentifier: TargetIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.controltower.model.EnableControlRequest = {
    import EnableControlRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.controltower.model.EnableControlRequest
      .builder()
      .controlIdentifier(
        ControlIdentifier.unwrap(controlIdentifier): java.lang.String
      )
      .targetIdentifier(
        TargetIdentifier.unwrap(targetIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.controltower.model.EnableControlRequest.ReadOnly =
    zio.aws.controltower.model.EnableControlRequest.wrap(buildAwsValue())
}
object EnableControlRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.controltower.model.EnableControlRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.controltower.model.EnableControlRequest =
      zio.aws.controltower.model
        .EnableControlRequest(controlIdentifier, targetIdentifier)
    def controlIdentifier: ControlIdentifier
    def targetIdentifier: TargetIdentifier
    def getControlIdentifier: ZIO[Any, Nothing, ControlIdentifier] =
      ZIO.succeed(controlIdentifier)
    def getTargetIdentifier: ZIO[Any, Nothing, TargetIdentifier] =
      ZIO.succeed(targetIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.controltower.model.EnableControlRequest
  ) extends zio.aws.controltower.model.EnableControlRequest.ReadOnly {
    override val controlIdentifier: ControlIdentifier =
      zio.aws.controltower.model.primitives
        .ControlIdentifier(impl.controlIdentifier())
    override val targetIdentifier: TargetIdentifier =
      zio.aws.controltower.model.primitives
        .TargetIdentifier(impl.targetIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.controltower.model.EnableControlRequest
  ): zio.aws.controltower.model.EnableControlRequest.ReadOnly = new Wrapper(
    impl
  )
}
