package zio.aws.controltower.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.controltower.model.primitives.ControlIdentifier
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EnabledControlSummary(
    controlIdentifier: Optional[ControlIdentifier] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.controltower.model.EnabledControlSummary = {
    import EnabledControlSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.controltower.model.EnabledControlSummary
      .builder()
      .optionallyWith(
        controlIdentifier.map(value =>
          ControlIdentifier.unwrap(value): java.lang.String
        )
      )(_.controlIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.controltower.model.EnabledControlSummary.ReadOnly =
    zio.aws.controltower.model.EnabledControlSummary.wrap(buildAwsValue())
}
object EnabledControlSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.controltower.model.EnabledControlSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.controltower.model.EnabledControlSummary =
      zio.aws.controltower.model
        .EnabledControlSummary(controlIdentifier.map(value => value))
    def controlIdentifier: Optional[ControlIdentifier]
    def getControlIdentifier: ZIO[Any, AwsError, ControlIdentifier] =
      AwsError.unwrapOptionField("controlIdentifier", controlIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.controltower.model.EnabledControlSummary
  ) extends zio.aws.controltower.model.EnabledControlSummary.ReadOnly {
    override val controlIdentifier: Optional[ControlIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.controlIdentifier())
        .map(value =>
          zio.aws.controltower.model.primitives.ControlIdentifier(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.controltower.model.EnabledControlSummary
  ): zio.aws.controltower.model.EnabledControlSummary.ReadOnly = new Wrapper(
    impl
  )
}
