package zio.aws.controltower.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.controltower.model.primitives.OperationIdentifier
import scala.jdk.CollectionConverters.*
final case class GetControlOperationRequest(
    operationIdentifier: OperationIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.controltower.model.GetControlOperationRequest = {
    import GetControlOperationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.controltower.model.GetControlOperationRequest
      .builder()
      .operationIdentifier(
        OperationIdentifier.unwrap(operationIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.controltower.model.GetControlOperationRequest.ReadOnly =
    zio.aws.controltower.model.GetControlOperationRequest.wrap(buildAwsValue())
}
object GetControlOperationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.controltower.model.GetControlOperationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.controltower.model.GetControlOperationRequest =
      zio.aws.controltower.model.GetControlOperationRequest(operationIdentifier)
    def operationIdentifier: OperationIdentifier
    def getOperationIdentifier: ZIO[Any, Nothing, OperationIdentifier] =
      ZIO.succeed(operationIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.controltower.model.GetControlOperationRequest
  ) extends zio.aws.controltower.model.GetControlOperationRequest.ReadOnly {
    override val operationIdentifier: OperationIdentifier =
      zio.aws.controltower.model.primitives
        .OperationIdentifier(impl.operationIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.controltower.model.GetControlOperationRequest
  ): zio.aws.controltower.model.GetControlOperationRequest.ReadOnly =
    new Wrapper(impl)
}
