package zio.aws.controltower.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetControlOperationResponse(
    controlOperation: zio.aws.controltower.model.ControlOperation
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.controltower.model.GetControlOperationResponse = {
    import GetControlOperationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.controltower.model.GetControlOperationResponse
      .builder()
      .controlOperation(controlOperation.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.controltower.model.GetControlOperationResponse.ReadOnly =
    zio.aws.controltower.model.GetControlOperationResponse.wrap(buildAwsValue())
}
object GetControlOperationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.controltower.model.GetControlOperationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.controltower.model.GetControlOperationResponse =
      zio.aws.controltower.model
        .GetControlOperationResponse(controlOperation.asEditable)
    def controlOperation: zio.aws.controltower.model.ControlOperation.ReadOnly
    def getControlOperation: ZIO[
      Any,
      Nothing,
      zio.aws.controltower.model.ControlOperation.ReadOnly
    ] = ZIO.succeed(controlOperation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.controltower.model.GetControlOperationResponse
  ) extends zio.aws.controltower.model.GetControlOperationResponse.ReadOnly {
    override val controlOperation
        : zio.aws.controltower.model.ControlOperation.ReadOnly =
      zio.aws.controltower.model.ControlOperation.wrap(impl.controlOperation())
  }
  def wrap(
      impl: software.amazon.awssdk.services.controltower.model.GetControlOperationResponse
  ): zio.aws.controltower.model.GetControlOperationResponse.ReadOnly =
    new Wrapper(impl)
}
