package zio.aws.controltower.model
import zio.prelude.data.Optional
import zio.aws.controltower.model.primitives.{TargetIdentifier, MaxResults}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListEnabledControlsRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    targetIdentifier: TargetIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.controltower.model.ListEnabledControlsRequest = {
    import ListEnabledControlsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.controltower.model.ListEnabledControlsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .targetIdentifier(
        TargetIdentifier.unwrap(targetIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.controltower.model.ListEnabledControlsRequest.ReadOnly =
    zio.aws.controltower.model.ListEnabledControlsRequest.wrap(buildAwsValue())
}
object ListEnabledControlsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.controltower.model.ListEnabledControlsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.controltower.model.ListEnabledControlsRequest =
      zio.aws.controltower.model.ListEnabledControlsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        targetIdentifier
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[String]
    def targetIdentifier: TargetIdentifier
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTargetIdentifier: ZIO[Any, Nothing, TargetIdentifier] =
      ZIO.succeed(targetIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.controltower.model.ListEnabledControlsRequest
  ) extends zio.aws.controltower.model.ListEnabledControlsRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.controltower.model.primitives.MaxResults(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val targetIdentifier: TargetIdentifier =
      zio.aws.controltower.model.primitives
        .TargetIdentifier(impl.targetIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.controltower.model.ListEnabledControlsRequest
  ): zio.aws.controltower.model.ListEnabledControlsRequest.ReadOnly =
    new Wrapper(impl)
}
