package zio.aws.controltower.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListEnabledControlsResponse(
    enabledControls: Iterable[zio.aws.controltower.model.EnabledControlSummary],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.controltower.model.ListEnabledControlsResponse = {
    import ListEnabledControlsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.controltower.model.ListEnabledControlsResponse
      .builder()
      .enabledControls(enabledControls.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.controltower.model.ListEnabledControlsResponse.ReadOnly =
    zio.aws.controltower.model.ListEnabledControlsResponse.wrap(buildAwsValue())
}
object ListEnabledControlsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.controltower.model.ListEnabledControlsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.controltower.model.ListEnabledControlsResponse =
      zio.aws.controltower.model.ListEnabledControlsResponse(
        enabledControls.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def enabledControls
        : List[zio.aws.controltower.model.EnabledControlSummary.ReadOnly]
    def nextToken: Optional[String]
    def getEnabledControls: ZIO[Any, Nothing, List[
      zio.aws.controltower.model.EnabledControlSummary.ReadOnly
    ]] = ZIO.succeed(enabledControls)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.controltower.model.ListEnabledControlsResponse
  ) extends zio.aws.controltower.model.ListEnabledControlsResponse.ReadOnly {
    override val enabledControls
        : List[zio.aws.controltower.model.EnabledControlSummary.ReadOnly] = impl
      .enabledControls()
      .asScala
      .map { item =>
        zio.aws.controltower.model.EnabledControlSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.controltower.model.ListEnabledControlsResponse
  ): zio.aws.controltower.model.ListEnabledControlsResponse.ReadOnly =
    new Wrapper(impl)
}
