package zio.aws.databrew.model
import scala.jdk.CollectionConverters._
sealed trait CompressionFormat {
  def unwrap: software.amazon.awssdk.services.databrew.model.CompressionFormat
}
object CompressionFormat {
  def wrap(
      value: software.amazon.awssdk.services.databrew.model.CompressionFormat
  ): zio.aws.databrew.model.CompressionFormat = value match {
    case software.amazon.awssdk.services.databrew.model.CompressionFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databrew.model.CompressionFormat.GZIP =>
      val r = GZIP
      r
    case software.amazon.awssdk.services.databrew.model.CompressionFormat.LZ4 =>
      val r = LZ4
      r
    case software.amazon.awssdk.services.databrew.model.CompressionFormat.SNAPPY =>
      val r = SNAPPY
      r
    case software.amazon.awssdk.services.databrew.model.CompressionFormat.BZIP2 =>
      val r = BZIP2
      r
    case software.amazon.awssdk.services.databrew.model.CompressionFormat.DEFLATE =>
      val r = DEFLATE
      r
    case software.amazon.awssdk.services.databrew.model.CompressionFormat.LZO =>
      val r = LZO
      r
    case software.amazon.awssdk.services.databrew.model.CompressionFormat.BROTLI =>
      val r = BROTLI
      r
    case software.amazon.awssdk.services.databrew.model.CompressionFormat.ZSTD =>
      val r = ZSTD
      r
    case software.amazon.awssdk.services.databrew.model.CompressionFormat.ZLIB =>
      val r = ZLIB
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databrew.model.CompressionFormat {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.CompressionFormat =
      software.amazon.awssdk.services.databrew.model.CompressionFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object GZIP extends zio.aws.databrew.model.CompressionFormat {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.CompressionFormat =
      software.amazon.awssdk.services.databrew.model.CompressionFormat.GZIP
  }
  case object LZ4 extends zio.aws.databrew.model.CompressionFormat {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.CompressionFormat =
      software.amazon.awssdk.services.databrew.model.CompressionFormat.LZ4
  }
  case object SNAPPY extends zio.aws.databrew.model.CompressionFormat {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.CompressionFormat =
      software.amazon.awssdk.services.databrew.model.CompressionFormat.SNAPPY
  }
  case object BZIP2 extends zio.aws.databrew.model.CompressionFormat {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.CompressionFormat =
      software.amazon.awssdk.services.databrew.model.CompressionFormat.BZIP2
  }
  case object DEFLATE extends zio.aws.databrew.model.CompressionFormat {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.CompressionFormat =
      software.amazon.awssdk.services.databrew.model.CompressionFormat.DEFLATE
  }
  case object LZO extends zio.aws.databrew.model.CompressionFormat {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.CompressionFormat =
      software.amazon.awssdk.services.databrew.model.CompressionFormat.LZO
  }
  case object BROTLI extends zio.aws.databrew.model.CompressionFormat {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.CompressionFormat =
      software.amazon.awssdk.services.databrew.model.CompressionFormat.BROTLI
  }
  case object ZSTD extends zio.aws.databrew.model.CompressionFormat {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.CompressionFormat =
      software.amazon.awssdk.services.databrew.model.CompressionFormat.ZSTD
  }
  case object ZLIB extends zio.aws.databrew.model.CompressionFormat {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.CompressionFormat =
      software.amazon.awssdk.services.databrew.model.CompressionFormat.ZLIB
  }
}
